<?php
/**
 * BuddyPress Single Members item Sub Navigation
 *
 * @since BuddyPress 3.0.0
 * @version 3.0.0
 */
?>

<?php
	$bp_nouveau = bp_nouveau();
	$has_nav    = bp_nouveau_has_nav( array( 'type' => 'secondary' ) );
	$nav_count  = count($bp_nouveau->sorted_nav);
	 $userID = get_current_user_id();
	if ( ! $has_nav || $nav_count <= 1 ) {
		unset( $bp_nouveau->sorted_nav, $bp_nouveau->displayed_nav, $bp_nouveau->object_nav );
		return;
	}
?>

<nav class="<?php bp_nouveau_single_item_subnav_classes(); ?>" id="subnav" role="navigation" aria-label="<?php esc_attr_e( 'Sub Menu', 'buddyboss' ); ?>">
	<ul class="subnav">
	<?php
		while ( bp_nouveau_nav_items() ) :
			bp_nouveau_nav_item();
		?>

			<li id="<?php bp_nouveau_nav_id(); ?>" class="<?php bp_nouveau_nav_classes(); ?>" <?php bp_nouveau_nav_scope(); ?>>
				<a href="<?php bp_nouveau_nav_link(); ?>" id="<?php bp_nouveau_nav_link_id(); ?>">
					<?php bp_nouveau_nav_link_text(); ?>

					<?php if ( bp_nouveau_nav_has_count() ) : ?>
						<span class="count"><?php bp_nouveau_nav_count(); ?></span>
					<?php endif; ?>
				</a>
			</li>

		<?php endwhile; ?>
	<?php
	 //$nav_item    = $bp_nouveau->current_nav_item;
	 //echo "======>".$nav_item.'======>'.bp_current_component();
	
	if(bp_current_component()=='settings'){ ?>
	  <li id="general-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="edit">
				<a href="<?php echo bp_core_get_user_domain($userID).'profile/edit/group/4'; ?>" id="edit">
						Edit Profile
				</a>
			</li>

		<li id="general-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="change-avatar">
				<a href="<?php echo bp_core_get_user_domain($userID).'profile/change-cover-image/'; ?>" id="change-avatar">
							Change Cover
				</a>
			</li>

			<li id="general-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="change-cover-image">
				<a href="<?php echo bp_core_get_user_domain($userID).'profile/change-avatar/'; ?>" id="change-cover-image">
					Change Avatar
				</a>
			</li>	
		
		<li id="general-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="general">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings'; ?>" id="general">
						Password
				</a>
			</li> 
		
			<li id="notifications-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="notifications">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings/notifications/'; ?>" id="notifications">
					Email Preferences
				</a>
			</li>
			<li id="profile-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="profile">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings/profile/'; ?>" id="profile">
					Privacy
									</a>
			</li>
			<li id="export-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="export">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings/export/'; ?>" id="export">
					Export Data
				</a>
			</li>
			<li id="delete-account-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="delete-account">
				<a href="<?php  echo bp_core_get_user_domain($userID); ?>/settings/delete-account/" id="delete-account">
					Delete Account
				</a>
			</li> 
		<?php if(bp_current_component()=='profile'){ ?>
	 	 	<li id="general-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="general">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings'; ?>" id="general">
						Password
				</a>
			</li> 
		
			<li id="notifications-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="notifications">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings/notifications/'; ?>" id="notifications">
					Email Preferences
				</a>
			</li>
			<li id="profile-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="profile">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings/profile/'; ?>" id="profile">
					Privacy
									</a>
			</li>
			<li id="export-personal-li" class="bp-personal-sub-tab" data-bp-user-scope="export">
				<a href="<?php echo bp_core_get_user_domain($userID).'settings/export/'; ?>" id="export">
					Export Data
				</a>
			</li>
		
		<?php }	?>

	</ul>
</nav><!-- .item-list-tabs#subnav -->
