<?php
/**
 * Feedback form
 *
 * @package    ReportAbuse
 * @subpackage Form
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */
?>
<?php
$email = $name = '';
if ( is_user_logged_in() ) {
	$user  = wp_get_current_user();
	$email = $user->user_email;
	$name  = bp_get_loggedin_user_fullname();
}
?>
<div class="bpmts-feedback-form-wrapper">
    <span class="bpmts-feedback-form-close-button">x</span>
    <div class="bpmts-feedback-form-status-message"></div>
	<?php $form_fields = bpmts_get_option( 'form_fields', array() ); ?>
    <form class="bpmts-feedback-form" method="post" action="">
		<?php do_action( 'bpmts_before_feedback_form' ); ?>

		<?php if ( in_array( 'subject', $form_fields, true ) ) : ?>
            <label class="bpmts-feedback-form-label bpmts-feedback-form-subject-label">
				<?php _e( 'Subject: ', 'buddypress-moderation-tools' ) ?>
                <input type="text" class="bpmts-feedback-form-subject" name="subject">
            </label>
			<?php do_action( 'bpmts_after_feedback_form_field_subject' ); ?>
		<?php endif; ?>

		<?php if ( in_array( 'message', $form_fields, true ) ) : ?>
            <label class="bpmts-feedback-form-label bpmts-feedback-form-message-label">
				<?php _e( 'Content: ', 'buddypress-moderation-tools' ) ?>
                <textarea type="text" name="message" class="bpmts-feedback-form-message"></textarea>
            </label>
			<?php do_action( 'bpmts_after_feedback_form_field_message' ); ?>
		<?php endif; ?>

		<?php if ( in_array( 'category', $form_fields, true ) ) : ?>
            <label class="bpmts-feedback-form-label bpmts-feedback-form-category-label">
                <?php echo bpmts_list_categories( array( 'active' => 1 ) ); ?>
            </label>
			<?php do_action( 'bpmts_after_feedback_form_field_category' ); ?>
		<?php endif; ?>

		<?php if ( in_array( 'name', $form_fields, true ) ) : ?>
            <label class="bpmts-feedback-form-label bpmts-feedback-form-name-label">
				<?php _e( 'Name: ', 'buddypress-moderation-tools' ) ?>
                <input type="text" class="bpmts-feedback-form-name" name="name" value="<?php echo esc_attr( $name );?>">
            </label>
			<?php do_action( 'bpmts_after_feedback_form_field_name' ); ?>
		<?php endif; ?>

	    <?php if ( in_array( 'email', $form_fields, true ) ) : ?>
            <label class="bpmts-feedback-form-label bpmts-feedback-form-subject-email">
			    <?php _e( 'Email: ', 'buddypress-moderation-tools' ) ?>
                <input type="text" class="bpmts-feedback-form-subject" name="email" value="<?php echo esc_attr( $email ); ?>">
            </label>
		    <?php do_action( 'bpmts_after_feedback_form_field_email' ); ?>
	    <?php endif; ?>

        <input type="hidden" name="action" value="bpmts_report_item">
        <input type="hidden" name="_wpnonce" value="<?php echo wp_create_nonce( 'bpmts-report-item' ) ?>">

	    <?php do_action( 'bpmts_before_feedback_form_submit' ); ?>

        <div class="bpmts-feedback-form-submit">
            <input type="submit" class="bpmts-feedback-form-submit-button" value="<?php _e( 'Report', 'buddypress-moderation-tools' ); ?>">
        </div>

		<?php do_action( 'bpmts_before_feedback_form' ); ?>
    </form>
</div>
