<?php
/**
 * Admin Settings Pages Helper.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Admin
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Admin;

use \Press_Themes\PT_Settings\Page;
use PressThemes\ModerationTools\Admin\Panels\Panel_General;
use PressThemes\ModerationTools\Admin\Panels\Panel_Notifications;

// Do not allow direct access over web.
defined( 'ABSPATH' ) || exit;

/**
 * Class Admin_Settings
 */
class Admin_Settings {

	/**
	 * Used to keep a reference of the Page, It will be used in rendering the view.
	 *
	 * @var \Press_Themes\PT_Settings\Page
	 */
	private $page;

	/**
	 * Show/render the setting page
	 */
	public function render() {
		$this->page->render();
	}

	/**
	 * Initialize the admin settings panel and fields
	 */
	public function init() {

		$this->page = new Page( 'bpmts-settings', __( 'BuddyPress Moderation<sup><small>(1.0.7)</small></sup>', 'buddypress-moderation-tools' ) );

		$this->add_general_settings();

		$reportables = bpmts_moderation_tools()->reportable_types->get_all();

		// Give the Reportable Types opportunity to add their own settings.
		foreach ( $reportables as $reportable ) {

			if ( ! $reportable->active ) {
				continue;
			}

			$reportable->add_admin_settings( $this->page );
		}

		//$this->add_notification_settings();

		do_action( 'bpmts_admin_settings_page', $this->page );

		// allow enabling options.
		$this->page->init();
	}

	/**
	 * Add general settings
	 */
	private function add_general_settings() {
		$panel = $this->page->add_panel( 'general', _x( 'General', 'Admin settings panel title', 'buddypress-moderation-tools' ) );
		Panel_General::build( $panel );
	}

	/**
	 * Add notification settings
	 */
	private function add_notification_settings() {
		$panel = $this->page->add_panel( 'notification', _x( 'Notification', 'Admin settings panel title', 'buddypress-moderation-tools' ) );
		Panel_Notifications::build( $panel );

	}
}
