<?php
/**
 * Category List page.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Admin/category
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

use PressThemes\ModerationTools\Models\Category;

// Do not allow direct access over web.
defined( 'ABSPATH' ) || exit;

?>
<div class="wrap bpmts-cat-page-wrap">
    <h1 class="wp-heading-inline"><?php _e( 'Categories', 'buddypress-moderation-tools' ); ?></h1>
    <hr class="wp-header-end">
<?php bpmts_admin_notice();?>
<div id="col-container" class="wp-clearfix">

    <div id="col-left">
        <div class="col-wrap">

            <div class="form-wrap">
                <h2><?php _e( 'Add New Category', 'buddypress-moderation-tools' ); ?></h2>
                <form id="bpmts-category-form" method="post" action="" class="bpmts-admin-form bpmts-add-category-form">

                    <?php wp_nonce_field( 'bpmts_add_category');?>

                    <div class="form-field form-required term-name-wrap">
                        <label for="bpmts-name"><?php _e( 'Name', 'buddypress-moderation-tools' ); ?></label>
                        <input name="name" id="bpmts-name" type="text" value="" size="40" aria-required="true">
                        <p> <?php _e( 'Name shown in the dropdown.', 'buddypress-moderation-tools' ); ?></p>
                    </div>

                    <div class="form-field bpmts-cat-form-field-active">
                        <label for="is_active"> <?php _e( 'Active?', 'buddypress-moderation-tools' ); ?></label>
                        <select name="is_active" class="postform">
                            <option value="1"><?php _e( 'Yes', 'buddypress-moderation-tools' ); ?></option>
                            <option value="0"><?php _e( 'No', 'buddypress-moderation-tools' ); ?></option>
                        </select>
                        <p><?php _e( "Inactive categories won't be shown to the user.", 'buddypress-moderation-tools' ); ?></p>
                    </div>

                    <p class="submit">
                        <input type="submit" name="submit" id="submit" class="button button-primary"
                               value="<?php _e( 'Add New Category', 'buddypress-moderation-tools' ); ?>">
                    </p>

                </form>
            </div>

        </div>
    </div><!-- /col-left -->

    <div id="col-right">
        <div class="col-wrap">

            <h2 class="screen-reader-text">Categories list</h2>
            <table class="wp-list-table widefat fixed striped tags">
                <thead>
                <tr>
                    <th scope="col" class="manage-column column-id">
                        <span>ID</span>
                    </th>

                    <th scope="col" id="name" class="manage-column column-name column-primary sortable desc">
                        <a><span>Name</span>
                            <span class="sorting-indicator"></span>
                        </a>
                    </th>

                    <th scope="col" class="manage-column column-description sortable desc">
                        <a href="#">
                            <span>Active</span><span class="sorting-indicator"></span>
                        </a>
                    </th>
                </tr>
                </thead>

                <tbody id="the-list">

                <?php $categories = Category::all(); ?>
                <?php if ( ! empty( $categories ) ): ?>
                <?php foreach ( $categories as $category ) : ?>
                        <?php

                            $edit_url = $this->get_entry_url( array( 'bpmts_cat_id'=> $category->id, 'bpmts_action'=> 'edit' ) );
                            $delete_url = wp_nonce_url( $this->get_entry_url( array( 'bpmts_cat_id'=> $category->id, 'bpmts_action'=> 'delete' ) ), 'bpmts_delete_category' );
                            $view_url = '';

                        ?>
                <tr>
                    <td class="bpmts-active column-active">
                        <span><?php echo $category->id; ?></span>
                    </td>
                    <td class="column-name has-row-actions column-primary">
                        <strong><a class="row-title" href="#"><?php echo $category->name; ?></a></strong>
                        <br>
                        <div class="row-actions">
                            <span class="edit"><a href="<?php echo esc_url( $edit_url);?>">Edit</a> | </span>
                            <span class="delete"><a href="<?php echo esc_url( $delete_url);?>" class="delete-tag aria-button-if-js">Delete</a> | </span>
                          <!--  <span class="view"><a href="<?php echo esc_url( $view_url);?>">View</a></span> -->
                        </div>

                    </td>

                    <td class="bpmts-active column-active">
                        <span><?php echo $category->is_active ? __( 'Yes', 'buddypress-moderation-tools' ) : __( 'No', 'buddypress-moderation-tools' ); ?></span>
                    </td>
                </tr>
	                <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3">
			                <?php _e( "You haven't created any categories yet.", 'buddypress-moderation-tools' );?>
                        </td>
                    </tr>
                <?php endif;?>

                </tbody>

                <tfoot>

                </tfoot>

            </table>
            <div class="tablenav bottom">
                <div class="form-wrap bpmts-admin-form-notes">
                    <p>
                        Categories allow you to organize the reports.
                    </p>

                </div>

            </div>
        </div><!-- /col-right -->

    </div>

</div>