<?php
/**
 * Collection Interface
 *
 * @package    ReportAbuse
 * @subpackage Reportable
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Contracts;

// No direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 0 );
}

/**
 * Collection interface to declare support for collections management.
 */
interface Collection {

	/**
	 * Add an item to collection.
	 *
	 * @param mixed $item collection item.
	 *
	 * @return bool
	 */
	public function add( $item );

	/**
	 * Add multiple items at once to the collection.
	 *
	 * @param array $routes items array.
	 *
	 * @return bool
	 */
	public function add_multiple( array $routes );

	/**
	 * Get an item from the collection.
	 *
	 * @param string|int $id item id.
	 *
	 * @return mixed
	 */
	public function get( $id );

	/**
	 * Get all items from the collection.
	 *
	 * @return array
	 */
	public function get_all();

	/**
	 * Check if the item by given id exists in collection.
	 *
	 * @param string $id item id.
	 *
	 * @return mixed
	 */
	public function has( $id );
}
