<?php
/**
 * Ajax action handler.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Handlers
 * @copyright  Copyright (c) 2018, BuddyDev
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Ravi Sharma, Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Handlers;

// Do not allow direct access over web.
defined( 'ABSPATH' ) || exit;


/**
 * Class Ajax_Request_Handler
 */
class Ajax_Request_Handler {

	/**
	 * Boot the handler.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callback for ajax request
	 */
	public function setup() {

		// Add item to moderation queue.
		add_action( 'wp_ajax_bpmts_report_item', array( $this, 'report' ) );
		add_action( 'wp_ajax_nopriv_bpmts_report_item', array( $this, 'report' ) );
	}

	/**
	 * Add item to moderation queue
	 */
	public function report() {
		// validate nonce.
		check_ajax_referer( 'bpmts-report-item', '_wpnonce', true );

		$status = bpmts_report_item( wp_unslash( $_POST ) );

		if ( is_wp_error( $status ) ) {
			wp_send_json_error( array( 'message' => $status->get_error_message() ) );
		} else {
			wp_send_json_success( array( 'message' => __( 'Thank you for reporting.', 'buddypress-moderation-tools' ) ) );
		}
	}
}
