<?php
/**
 * Short Description
 *
 * @package    bp29_dev
 * @subpackage ${NAMESPACE}
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Messages;

/**
 * Message Base class.
 *
 * @property-read string $subject message subject.
 * @property-read string $message message content.
 */
class Message {

	/**
	 * Message subject.
	 *
	 * @var string
	 */
	protected $subject = '';

	/**
	 * Message content
	 *
	 * @var string
	 */
	protected $message = '';

	/**
	 * Supported notification channels.
	 *
	 * @var array
	 */
	protected $channels = array( 'email' );

	/**
	 * Message constructor.
	 *
	 * @param string $subject subject.
	 * @param string $message message.
	 * @param array  $channels supported channels.
	 */
	public function __construct( $subject, $message, $channels = array( 'email' ) ) {
		$this->subject  = $subject;
		$this->message  = $message;
		$this->channels = $channels;
	}

	/**
	 * Get a property.
	 *
	 * @param string $name property name.
	 *
	 * @return mixed|null
	 */
	public function __get( $name ) {
		return property_exists( $this, $name ) ? $this->{$name} : null;
	}

	/**
	 * Check if the given channel is supported.
	 *
	 * @param string $channel channel identifier.
	 *
	 * @return bool
	 */
	public function supports_channel( $channel ) {
		return $this->channels && is_array( $this->channels ) && in_array( $channel, $this->channels, true );
	}
}
