<?php
/**
 * Admin Settings Pages for the Forum.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BBPress\Reply
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress\Reply\Admin;

use Press_Themes\PT_Settings\Panel;

// Exit if the file is accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Reply_Settings_Panel {

	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$defaults = bpmts_get_default_settings();

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/reply-moderation-settings/';
		$panel->add_section( 'report-reply-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'bbp_reply_auto_hide',
			      'label'   => __( 'Auto hide reply?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bbp_reply_auto_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, reported replies will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bbp_reply_threshold',
			      'label'   => __( 'Forum hiding threshold ', 'buddypress-moderation-tools' ),
			      'type'    => 'number',
			      'default' => $defaults['bbp_reply_threshold'],
			      'desc'    => __( 'How many users should report the reply before it gets hidden?', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bbp_reply_hide_type',
			      'label'   => __( 'Hide reply for', 'buddypress-moderation-tools' ),
			      'type'    => 'multicheck',
			      'default' => $defaults['bbp_reply_hide_type'],
			      'options' => array(
				      'all'      => __( 'All when threshold is reached.', 'buddypress-moderation-tools' ),
				      'reporter' => __( 'Reporters when they report the activity', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'Enable auto hiding of reply for the reporters or all users when threshold is reached.', 'buddypress-moderation-tools' ),
		      ) );

		// Notification.
		$section = $panel->add_section( 'report-reply-new-report-admin-notification', __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_reply_notify_admin_on_report',
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_reply_notify_admin_on_report'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Notify admin if a reply is reported.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_reply_admin_reported_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_reply_admin_reported_subject'],
		) )->add_field( array(
			'name'    => 'bbp_reply_admin_reported_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_reply_admin_reported_message'],
		) );

		// Notification.
		$section = $panel->add_section( 'report-reply-admin-threshold-notification', __( 'Admin notification on hiding reply', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_reply_notify_admin_on_hide',
			'label'   => __( 'Notify admin when reply is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_reply_notify_admin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Admin will only be notified when a reply is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_reply_admin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_reply_admin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bbp_reply_admin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_reply_admin_hidden_message'],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'report-reply-user-threshold-notification', __( 'User notification on hiding reply', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_reply_notify_user_on_hide',
			'label'   => __( 'Notify reply owner when their reply is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_reply_notify_user_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their reply is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_reply_user_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_reply_user_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bbp_reply_user_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_reply_user_hidden_message'],
		) );

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-reply-user-notification-activity-restore', __( 'User notification on restoring reply', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_reply_notify_user_on_restore',
			'label'   => __( 'Notify reply creator when their reply is restored?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_reply_notify_user_on_restore'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'reply creator will be notified when their reply is restored.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_reply_user_restored_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_reply_user_restored_subject'],
		) )->add_field( array(
			'name'    => 'bbp_reply_user_restored_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_reply_user_restored_message'],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-reply-notification-reply-delete', __( 'User notification on reply delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_reply_notify_user_on_delete',
			'label'   => __( 'Notify user when their reply is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_reply_notify_user_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their reply is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_reply_user_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_reply_user_deleted_subject'],
		) )->add_field( array(
			'name'    => 'bbp_reply_user_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_reply_user_deleted_message'],
		) );
	}
}