<?php
/**
 * BuddyPress Moderation Tools:- Topic Query filter.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BBPress\Topic
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress\Topic\Filters;

use PressThemes\ModerationTools\Filters\Query_Filter;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter Topic Query.
 */
class Topic_Query_Filter extends Query_Filter {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {

		$this->item_type = bbp_get_topic_post_type();

		$this->settings = array(
			'auto_hide' => bpmts_get_option( 'bbp_topic_auto_hide', 0 ),
			'hide_type' => bpmts_get_option( 'bbp_topic_hide_type', array( 'all' ) ),
		);

		// hide posts from list everywhere.
		add_action( 'posts_where', array( $this, 'exclude_in_listing' ), 200, 2 );
	}

	/**
	 * Exclude posts from query.
	 *
	 * @param string    $sql Concatenated SQL statement.
	 * @param \WP_Query $query Query object.
	 *
	 * @return string
	 */
	public function exclude_in_listing( $sql, $query ) {
		// do not hide users inside the admin.
		if ( is_super_admin() || ( is_admin() && ! defined( 'DOING_AJAX' ) ) ) {
			return $sql;
		}

		$queried_post_type = $query->get( 'post_type' );
		$hide              = true;
		if ( empty( $queried_post_type ) ) {
			$hide = true;
		} elseif ( is_array( $queried_post_type ) && ! in_array( $this->item_type, $queried_post_type, true ) ) {
			$hide = false;
		} elseif ( $queried_post_type !== $this->item_type ) {
			$hide = false;
		}

		if ( ! $hide ) {
			return $sql;
		}

		// if filter is not needed.
		if ( $this->hide_for_reporters_enabled() ) {
			$hidden_reporters_sql = $this->get_sql_for_reported_items( get_current_user_id(), $this->item_type );

			$sql .= " AND ID NOT IN($hidden_reporters_sql)";
		}

		if ( $this->hide_for_all_enabled() ) {
			$hidden_all_sql = $this->get_sql_for_hidden_items( $this->item_type );

			$sql .= " AND ID NOT IN ({$hidden_all_sql}) ";
		}

		return $sql;
	}
}
