<?php
/**
 * Admin Settings Pages for the Activity Comment.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BuddyPress\Activity
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity_Comment\Admin;

use Press_Themes\PT_Settings\Panel;

// Exit if the file is accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Activity_Comment_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/activity-comment-moderation-settings/';
		$defaults = bpmts_get_default_settings();

		$panel->add_section( 'report-activity-comment-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'bp_acomment_auto_hide',
			      'label'   => __( 'Auto hide comment?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bp_acomment_auto_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, reported replies will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )
			->add_field( array(
				'name'    => 'bp_acomment_threshold',
				'label'   => __( 'activity hiding threshold ', 'buddypress-moderation-tools' ),
				'type'    => 'number',
				'default' => $defaults['bp_acomment_threshold'],
				'desc'    => __( 'How many users should report the comment before it gets hidden?', 'buddypress-moderation-tools' ),
			) )
			->add_field( array(
				'name'    => 'bp_acomment_hide_type',
				'label'   => __( 'Hide for', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $defaults['user_hide_type'],
				'options' => array(
					'all' => __( 'All', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporters', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'Hides the comments from logged in reporters.', 'buddypress-moderation-tools' ),
			) );

		// Notification.
		$section = $panel->add_section( 'report-activity-comment-new-report-admin-notification', __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_acomment_notify_admin_on_report',
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_acomment_notify_admin_on_report'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Notify admin if a activity comment is reported.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_acomment_admin_reported_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_acomment_admin_reported_subject'],
		) )->add_field( array(
			'name'    => 'bp_acomment_admin_reported_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_acomment_admin_reported_message'],
		) );

		// Notification.
		$section = $panel->add_section( 'report-activity-comment-admin-threshold-notification', __( 'Admin notification on hiding activity', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_acomment_notify_admin_on_hide',
			'label'   => __( 'Notify admin when user is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_acomment_notify_admin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Admin will only be notified when a activity comment is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_acomment_admin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_acomment_admin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bp_acomment_admin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_acomment_admin_hidden_message'],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'report-activity-comment-threshold-notification', __( 'User notification on hiding comment', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_acomment_notify_user_on_hide',
			'label'   => __( 'Notify user when their comment is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_acomment_notify_user_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their comment is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_acomment_user_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_acomment_user_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bp_acomment_user_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_acomment_user_hidden_message'],
		));

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-activity-comment-user-notification-activity-restore', __( 'User notification on restoring comment', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_acomment_notify_user_on_restore',
			'label'   => __( 'Notify user when their comment is restored?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_acomment_notify_user_on_restore'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will notified when their activity comment is restored.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_acomment_user_restored_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_acomment_user_restored_subject'],
		) )->add_field( array(
			'name'    => 'bp_acomment_user_restored_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_acomment_user_restored_message'],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-activity-comment-notification-activity-delete', __( 'User notification on comment delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_acomment_notify_user_on_delete',
			'label'   => __( 'Notify user when their comment is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_acomment_notify_user_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their comment is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_acomment_user_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_acomment_user_deleted_subject'],
		) )->add_field( array(
			'name'    => 'bp_acomment_user_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_acomment_user_deleted_message'],
		) );

	}
}

