<?php
/**
 * Admin Settings Pages for the Activity.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BuddyPress\Activity
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity\Admin;

use Press_Themes\PT_Settings\Panel;

// Exit if the file is accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Activity_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$defaults = bpmts_get_default_settings();

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/activity-moderation-settings/';
		$panel->add_section( 'report-activity-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'bp_activity_auto_hide',
			      'label'   => __( 'Auto hide activity?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bp_activity_auto_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, reported activities will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )
			->add_field( array(
				'name'    => 'bp_activity_threshold',
				'label'   => __( 'activity hiding threshold ', 'buddypress-moderation-tools' ),
				'type'    => 'number',
				'default' => $defaults['bp_activity_threshold'],
				'desc'    => __( 'How many users should report the activity before it gets hidden?', 'buddypress-moderation-tools' ),
			) )
			->add_field( array(
				'name'    => 'bp_activity_hide_type',
				'label'   => __( 'Hide activity for', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $defaults['bp_activity_hide_type'],
				'options' => array(
					'all'      => __( 'All when threshold is reached.', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporters when they report the activity', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'Enable auto hiding of activity for the reporters or all users when threshold is reached.', 'buddypress-moderation-tools' ),
			) );

		// Notification.
		$section = $panel->add_section( 'report-activity-new-report-admin-notification', __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_activity_notify_admin_on_report',
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_activity_notify_admin_on_report'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Notify admin if a activity is reported.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_activity_admin_reported_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_activity_admin_reported_subject'],
		) )->add_field( array(
			'name'    => 'bp_activity_admin_reported_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_activity_admin_reported_message'],
		) );

		// Notification.
		$section = $panel->add_section( 'report-activity-admin-threshold-notification', __( 'Admin notification on hiding activity', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_activity_notify_admin_on_hide',
			'label'   => __( 'Notify admin when user is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_activity_notify_admin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Admin will only be notified when a activity is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_activity_admin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_activity_admin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bp_activity_admin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_activity_admin_hidden_message'],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'report-activity-user-threshold-notification', __( 'User notification on hiding activity', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_activity_notify_user_on_hide',
			'label'   => __( 'Notify activity owner when their activity is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_activity_notify_user_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their activity is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_activity_user_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_activity_user_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bp_activity_user_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_activity_user_hidden_message'],
		));

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-activity-user-notification-activity-restore', __( 'User notification on restoring activity', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_activity_notify_user_on_restore',
			'label'   => __( 'Notify activity creator when their activity is restored?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_activity_notify_user_on_restore'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'activity creator will be notified when their activity is restored.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_activity_user_restored_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_activity_user_restored_subject'],
		) )->add_field( array(
			'name'    => 'bp_activity_user_restored_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_activity_user_restored_message'],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-activity-notification-activity-delete', __( 'User notification on activity delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_activity_notify_user_on_delete',
			'label'   => __( 'Notify user when their activity is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_activity_notify_user_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their activity is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_activity_user_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_activity_user_deleted_subject'],
		) )->add_field( array(
			'name'    => 'bp_activity_user_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_activity_user_deleted_message'],
		) );

	}
}

