<?php
/**
 * Admin Settings Pages for the Group.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Report_Types\BuddyPress\Group
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Group\Admin;

// Exit if the file is accessed directly over web.
use Press_Themes\PT_Settings\Panel;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Group_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {

		$defaults = bpmts_get_default_settings();

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/group-moderation-settings/';
		$panel->add_section( 'report-group-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'bp_group_auto_hide',
			      'label'   => __( 'Auto hide group?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bp_group_auto_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, reported groups will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )
			->add_field( array(
				'name'    => 'bp_group_threshold',
				'label'   => __( 'Group hiding threshold ', 'buddypress-moderation-tools' ),
				'type'    => 'number',
				'default' => $defaults['bp_group_threshold'],
				'desc'    => __( 'How many users should report the group before it gets hidden?', 'buddypress-moderation-tools' ),
			) )
			->add_field( array(
				'name'    => 'bp_group_hide_type',
				'label'   => __( 'Hide for', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $defaults['bp_group_hide_type'],
				'options' => array(
					'all'      => __( 'All', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporters', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'Hides the groups from logged in reporters or all.', 'buddypress-moderation-tools' ),
			) );

		// Notification.
		$section = $panel->add_section( 'report-group-new-report-admin-notification', __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_group_notify_admin_on_report',
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_group_notify_admin_on_report'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Notify admin if a group is reported.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_group_admin_reported_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_group_admin_reported_subject'],
		) )->add_field( array(
			'name'    => 'bp_group_admin_reported_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_group_admin_reported_message'],
		) );

		// Notification.
		$section = $panel->add_section( 'report-group-admin-threshold-notification', __( 'Admin notification on hiding group', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_group_notify_admin_on_hide',
			'label'   => __( 'Notify admin when group is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_group_notify_admin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Admin will only be notified when a group is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_group_admin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_group_admin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bp_group_admin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_group_admin_hidden_message'],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'report-group-gadmin-threshold-notification', __( 'Group admin user(s) notification on hiding group', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_group_notify_gadmin_on_hide',
			'label'   => __( 'Notify group admins when their group is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_group_notify_gadmin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Group admins will be notified when their group is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_group_gadmin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_group_gadmin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bp_group_gadmin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_group_gadmin_hidden_message'],
		));

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-group-user-notification-group-restore', __( 'Group admin notification on restoring group', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_group_notify_gadmin_on_restore',
			'label'   => __( 'Notify group admin when their group is restored?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_group_notify_gadmin_on_restore'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Group admin will be notified when their group is restored.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_group_gadmin_restored_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_group_gadmin_restored_subject'],
		) )->add_field( array(
			'name'    => 'bp_group_gadmin_restored_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_group_gadmin_restored_message'],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-group-notification-group-delete', __( 'Group admin notification on group delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bp_group_notify_gadmin_on_delete',
			'label'   => __( 'Notify user when their group is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bp_group_notify_gadmin_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their group is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bp_group_gadmin_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bp_group_gadmin_deleted_subject'],
		) )->add_field( array(
			'name'    => 'bp_group_gadmin_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bp_group_gadmin_deleted_message'],
		) );
		/*
		$panel->add_section( 'group-settings',  _x( 'Group Settings', 'Admin settings section title', 'buddypress-moderation-tools' ), sprintf( _x( 'For more details, please view <a href="%s">documentation</a>.', 'admin section description', 'buddypress-moderation-tools' ), $doc_link ) )

		      ->add_field( array(
			      'name'    => 'bp_group_admin_can_moderate',
			      'label'   => _x( 'Allow group admin', 'Admin settings field label', 'buddypress-moderation-tools' ),
			      'desc'    => _x( 'If enable group admin can moderate items of their group', 'Admin settings field desc', 'buddypress-moderation-tools' ),
			      'type'    => 'checkbox',
			      'default' => $defaults['bp_group_admin_can_moderate'],
		      ) );
		*/
	}
}

