<?php
/**
 * BuddyPress Moderation Tools:- Group Message Factory.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Group
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Group\Messages;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Message factory.
 */
class Group_Message_Factory {

	/**
	 * Get the message template/Message Builder.
	 *
	 * @param string $action current action.
	 *
	 * @return null|Group_Message_Builder
	 */
	public static function build( $action ) {
		$message = null;

		switch ( $action ) {

			case 'admin-reported':
				$subject = bpmts_get_option( 'bp_group_admin_reported_subject' );
				$content = bpmts_get_option( 'bp_group_admin_reported_message' );
				$message = new Group_Message_Builder( $subject, $content );
				break;

			case 'admin-hidden':
				$subject = bpmts_get_option( 'bp_group_admin_hidden_subject' );
				$content = bpmts_get_option( 'bp_group_admin_hidden_message' );
				$message = new Group_Message_Builder( $subject, $content );
				break;

			case 'user-hidden':
				$subject = bpmts_get_option( 'bp_group_gadmin_hidden_subject' );
				$content = bpmts_get_option( 'bp_group_gadmin_hidden_message' );
				$message = new Group_Message_Builder( $subject, $content );
				break;

			case 'user-restored':
				$subject = bpmts_get_option( 'bp_group_gadmin_restored_subject' );
				$content = bpmts_get_option( 'bp_group_gadmin_restored_message' );
				$message = new Group_Message_Builder( $subject, $content );
				break;

			case 'user-deleted': // may be a bit bad naming here.
				$subject = bpmts_get_option( 'bp_group_gadmin_deleted_subject' );
				$content = bpmts_get_option( 'bp_group_gadmin_deleted_message' );
				$message = new Group_Message_Builder( $subject, $content );
				break;

		}

		return $message;
	}
}
