<?php
/**
 * ReportAbuse:- User UI Helper.
 *
 * @package    ModerationTools
 * @subpackage Reportable_Types\Comment_Type\Handlers
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Comment_Type\Handlers;

// Exit if files access directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Buttons & Messages management.
 */
class Comment_Type_UI_Helper {

	/**
	 * Comment type.
	 *
	 * @var string
	 */
	private $comment_type = '';

	/**
	 * Boot this class.
	 *
	 * @param string $comment_type comment type.
	 */
	public static function boot( $comment_type ) {
		$self               = new self();
		$self->comment_type = $comment_type;
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// filter body.
		if ( is_user_logged_in() && is_super_admin() ) {
			//add_filter( 'body_class', array( $this, 'add_body_class' ) );
			//add_filter( 'post_class', array( $this, 'add_list_class' ) );
		}

		// Add Buttons.
		add_action( 'comment_text', array( $this, 'add_report_buttons' ), 1001, 3 );
	}

	/**
	 * Add appropriate class to body.
	 *
	 * @param array $classes css classes.
	 *
	 * @return array
	 */
	public function add_body_class( $classes ) {

		if ( ! is_user_logged_in() ) {
			return $classes;
		}

		if ( is_singular( $this->comment_type ) ) {
			$classes[] = bpmts_is_item_hidden( get_queried_object_id(), $this->comment_type ) ? "bpmts-displayed-item-hidden bpmts-displayed-{$this->comment_type}-hidden" : "bpmts-displayed-item-clean bpmts-displayed-{$this->comment_type}-clean";
		}

		return $classes;
	}

	/**
	 * Add extra class to member list entry.
	 *
	 * @param array $classes classes.
	 *
	 * @return array
	 */
	public function add_list_class( $classes ) {
		$classes[] = bpmts_is_item_hidden( get_the_ID(), $this->comment_type ) ? "bpmts-item-entry-hidden bpmts-post-type-entry-{$this->comment_type}-hidden" : "bpmts-item-entry-clean bpmts-post-type-entry-{$this->comment_type}-clean";

		return $classes;
	}

	/**
	 * Add button to single member header.
	 *
	 * @param string           $comment_text Text of the current comment.
	 * @param \WP_Comment|null $comment      The comment object.
	 * @param array            $args         An array of arguments.
	 *
	 * @return string
	 */
	public function add_report_buttons( $comment_text, $comment, $args ) {

		if ( $comment->comment_type === $this->comment_type && bpmts_user_can_report() ) {
			$comment_text .= bpmts_get_report_button( array(
				'item_id'    => $comment->comment_ID,
				'item_type'  => $this->comment_type,
				'context'    => $this->comment_type,
				'context_id' => $comment->comment_ID,
			) );
		}

		return $comment_text;
	}
}
