<?php
/**
 * Reportable support for post types.
 *
 * @package    BuddyPressModerationTools
 * @subpackage Reportable_Types
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

/**
 * @contributor: Ravi Sharma(raviousprime)
 */

namespace PressThemes\ModerationTools\Reportable_Types\Geodirectory;

use PressThemes\ModerationTools\Reportable_Types\Post_Type\Reportable_Post_Type;
use PressThemes\ModerationTools\Reportable_Types\Post_Type\Filters\Post_Type_Query_Filter;
use PressThemes\ModerationTools\Reportable_Types\Post_Type\Handlers\Post_Type_Action_Handler;
use PressThemes\ModerationTools\Reportable_Types\Geodirectory\Handlers\Geodirectory_UI_Helper;

// Exit if access directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Reportable post type
 */
class Reportable_Type_Geodirectory extends Reportable_Post_Type {

	/**
	 * Setup hooks. Called after boot.
	 */
	public function setup() {
		Post_Type_Action_Handler::boot( $this->type );
		Post_Type_Query_Filter::boot( $this->type );
		Geodirectory_UI_Helper::boot( $this->type );
	}
}
