<?php
/**
 * Admin Settings Pages for the Post type.
 * @package    ReportAbuse
 * @subpackage Report_Types\BuddyPress\Group
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Post_Type;


use Press_Themes\PT_Settings\Panel;

// Exit if the file is accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Post_Type_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel  $panel panel object.
	 * @param string $post_type post type.
	 */
	public static function build( Panel $panel, $post_type = 'post' ) {

		$settings = bpmts_get_default_settings();

		$defaults = array(
			"post_type_{$post_type}_auto_hide"                => $settings['post_auto_hide'],
			"post_type_{$post_type}_threshold"                => $settings['post_threshold'],
			"post_type_{$post_type}_hide_type"                => $settings['post_hide_type'],

			"post_type_{$post_type}_notify_admin_on_report"   => $settings['post_notify_admin_on_report'],
			"post_type_{$post_type}_admin_reported_subject"   => $settings['post_admin_reported_subject'],
			"post_type_{$post_type}_admin_reported_message"   => $settings['post_admin_reported_message'],

			"post_type_{$post_type}_notify_admin_on_hide"     => $settings['post_notify_admin_on_hide'],
			"post_type_{$post_type}_admin_hidden_subject"     => $settings['post_admin_hidden_subject'],
			"post_type_{$post_type}_admin_hidden_message"     => $settings['post_admin_hidden_message'],

			"post_type_{$post_type}_notify_author_on_hide"    => $settings['post_notify_author_on_hide'],
			"post_type_{$post_type}_author_hidden_subject"    => $settings['post_author_hidden_subject'],
			"post_type_{$post_type}_author_hidden_message"    => $settings['post_author_hidden_message'],

			"post_type_{$post_type}_notify_author_on_restore" => $settings['post_notify_author_on_restore'],
			"post_type_{$post_type}_author_restored_subject"  => $settings['post_author_restored_subject'],
			"post_type_{$post_type}_author_restored_message"  => $settings['post_author_restored_message'],

			"post_type_{$post_type}_notify_author_on_delete" => $settings['post_notify_author_on_delete'],
			"post_type_{$post_type}_author_deleted_subject"  => $settings['post_author_deleted_subject'],
			"post_type_{$post_type}_author_deleted_message"  => $settings['post_author_deleted_message'],
		);

		$post_type_object = get_post_type_object( $post_type );

		if ( ! $post_type_object ) {
			return;
		}

		$singular_name = $post_type_object->labels->singular_name;

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/settings-post-type';

		$panel->add_section( "report-ptype-{$post_type}-general-settings", __( 'General', 'buddypress-moderation-tools' ) )
			->add_field( array(
				'name'    => "post_type_{$post_type}_auto_hide",
				/*translator: post type label name*/
				'label'   => sprintf( __( 'Auto hide %s?', 'buddypress-moderation-tools' ), $singular_name ),
				'type'    => 'radio',
				'default' => $defaults[ "post_type_{$post_type}_auto_hide" ],
				'options' => array(
					1 => __( 'Yes', 'buddypress-moderation-tools' ),
					0 => __( 'No', 'buddypress-moderation-tools' ),
				),
				/*translator: post type label name*/
				'desc'    => sprintf( __( 'If enabled, reported %s will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ), $singular_name ),
			) )
			->add_field( array(
				'name'    => "post_type_{$post_type}_threshold",
				'label'   => sprintf( __( '%s hiding threshold ', 'buddypress-moderation-tools' ), $singular_name ),
				'type'    => 'number',
				'default' => $defaults[ "post_type_{$post_type}_threshold" ],
				'desc'    => sprintf( __( 'How many users should report the %s before it gets hidden?', 'buddypress-moderation-tools' ), $singular_name ),
			) )
			->add_field( array(
				'name'    => "post_type_{$post_type}_hide_type",
				'label'   => __( 'Hide for', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $defaults[ "post_type_{$post_type}_hide_type" ],
				'options' => array(
					'all'      => __( 'All', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporters', 'buddypress-moderation-tools' ),
				),
				'desc'    => sprintf( __( 'Hides the %s from logged in reporters.', 'buddypress-moderation-tools' ), $singular_name ),
			) );

		// Notification.
		$section = $panel->add_section( "report-post-type-{$post_type}-new-report-admin-notification", __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_notify_admin_on_report",
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults[ "post_type_{$post_type}_notify_admin_on_report" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'Notify admin if %s is reported.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_admin_reported_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "post_type_{$post_type}_admin_reported_subject" ],
		) )->add_field( array(
			'name'    => "post_type_{$post_type}_admin_reported_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "post_type_{$post_type}_admin_reported_message" ],
		) );

		// Notification.
		$section = $panel->add_section( "report-post-type-{$post_type}-admin-threshold-notification", __( 'Admin notification on hiding entry', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_notify_admin_on_hide",
			'label'   => sprintf( __( 'Notify admin when %s is hidden?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "post_type_{$post_type}_notify_admin_on_hide" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'Admin will only be notified when a %s is hidden.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_admin_hidden_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "post_type_{$post_type}_admin_hidden_subject" ],
		) )->add_field( array(
			'name'    => "post_type_{$post_type}_admin_hidden_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "post_type_{$post_type}_admin_hidden_message" ],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( "report-post-type-{$post_type}-author-threshold-notification", __( 'Author/creator notification on hiding', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_notify_author_on_hide",
			'label'   => sprintf( __( 'Notify author when their %s is hidden?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "post_type_{$post_type}_notify_author_on_hide" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'User will be notified when their %s is hidden.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_author_hidden_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "post_type_{$post_type}_author_hidden_subject" ],
		) )->add_field( array(
			'name'    => "post_type_{$post_type}_author_hidden_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "post_type_{$post_type}_author_hidden_message" ],
		));

		// User restore notification.
		// Notification.
		$section = $panel->add_section( "report-post-type-{$post_type}-author-notification-restore", __( 'Author Notification on restoration', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_notify_author_on_restore",
			'label'   => sprintf( __( 'Notify author when their %s is restored?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "post_type_{$post_type}_notify_author_on_restore" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'User will be notified when their %s is restored.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_author_restored_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "post_type_{$post_type}_author_restored_subject" ],
		) )->add_field( array(
			'name'    => "post_type_{$post_type}_author_restored_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "post_type_{$post_type}_author_restored_message" ],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( "report-post-type-{$post_type}-notification-delete", __( 'Author notification on delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_notify_author_on_delete",
			'label'   => sprintf( __( 'Notify user when their %s is deleted?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "post_type_{$post_type}_notify_author_on_delete" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'User will be notified when their %s is deleted by admin.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "post_type_{$post_type}_author_deleted_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "post_type_{$post_type}_author_deleted_subject" ],
		) )->add_field( array(
			'name'    => "post_type_{$post_type}_author_deleted_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "post_type_{$post_type}_author_deleted_message" ],
		) );

	}
}

