<?php
/**
 * Post Type Message Builder.
 *
 * @package    BudyPressModerationTools
 * @subpackage Post_Type
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Post_Type\Messages;

use PressThemes\ModerationTools\Messages\Message_Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Post Type message builder.
 */
class Post_Type_Message_Builder extends Message_Builder {

	/**
	 * Token map.
	 *
	 * @param \WP_Post $item item.
	 *
	 * @return array
	 */
	public function item_tokens_map( $item ) {
		$post_type_object = get_post_type_object( $item->post_type );

		if ( ! $post_type_object ) {
			return array();
		}

		return array(
			'{item.type}'  => $post_type_object->labels->name,
			'{item.label}' => $item->post_title,
			'{item.url}'   => get_permalink( $item ),
		);
	}
}

