<?php
/**
 * Post Type Message Factory.
 *
 * @package    BuddyPressModerationTools
 * @subpackage Post_Type
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Post_Type\Messages;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Message factory.
 */
class Post_Type_Message_Factory {

	/**
	 * Get the message template/Message Builder.
	 *
	 * @param string $action current action.
	 * @param string $type post type name.
	 *
	 * @return null|Post_Type_Message_Builder
	 */
	public static function build( $action, $type = 'post' ) {
		$message = null;

		switch ( $action ) {

			case 'admin-reported':
				$subject = bpmts_get_option( "post_type_{$type}_admin_reported_subject" );
				$content = bpmts_get_option( "post_type_{$type}_admin_reported_message" );
				$message = new Post_Type_Message_Builder( $subject, $content );
				break;

			case 'admin-hidden':
				$subject = bpmts_get_option( "post_type_{$type}_admin_hidden_subject" );
				$content = bpmts_get_option( "post_type_{$type}_admin_hidden_message" );
				$message = new Post_Type_Message_Builder( $subject, $content );
				break;

			case 'user-hidden':
				$subject = bpmts_get_option( "post_type_{$type}_author_hidden_subject" );
				$content = bpmts_get_option( "post_type_{$type}_author_hidden_message" );
				$message = new Post_Type_Message_Builder( $subject, $content );
				break;

			case 'user-deleted': // may be a bit bad naming here.
				$subject = bpmts_get_option( "post_type_{$type}_author_deleted_subject" );
				$content = bpmts_get_option( "post_type_{$type}_author_deleted_message" );
				$message = new Post_Type_Message_Builder( $subject, $content );
				break;

			case 'user-restored':
				$subject = bpmts_get_option( "post_type_{$type}_author_restored_subject" );
				$content = bpmts_get_option( "post_type_{$type}_author_restored_message" );
				$message = new Post_Type_Message_Builder( $subject, $content );
				break;
		}

		return $message;
	}
}
