<?php

/** prevent direct access */
defined( 'ABSPATH' ) || exit();

/** check if not class `WP_Dark_Mode_Admin` exists yet */
if ( ! class_exists( 'WP_Dark_Mode_Admin' ) ) {
	class WP_Dark_Mode_Admin {

		/**
		 * @var null
		 */
		private static $instance = null;

		/**
		 * Admin constructor.
		 */
		public function __construct() {
			add_action( 'admin_init', [ $this, 'display_notices' ], 999 );

			//usage chart
			add_action( 'wp_ajax_get_visit_usage', [ $this, 'get_visit_usage' ] );

		}

		public function get_visit_usage() {
			$length = ! empty( $_REQUEST['length'] ) ? intval( $_REQUEST['length'] ) : 30;

			$visits = get_option( 'wp_dark_mode_visits' );
			$usages = get_option( 'wp_dark_mode_usage' );

			$visits = array_slice( $visits, - $length, $length, true );

			$values = [];
			$labels = [];

			if ( ! empty( $visits ) ) {
				foreach ( $visits as $date => $visit ) {
					$usage = ! empty( $usages[ $date ] ) ? $usages[ $date ] : 0;

					if ( $visit < 0 ) {
						$visit = 0;
					}

					if ( $usage < 0 ) {
						$usage = 0;
					}

					$labels[] = $date;
					$values[] = ceil( ( $usage / $visit ) * 100 );

				}
			}

			ob_start();
			printf( '<canvas id="wp_dark_mode_chart" height="300" data-labels=\'%s\' data-values=\'%s\'></canvas>', json_encode( $labels ),
				json_encode( $values ) );
			$html = ob_get_clean();

			wp_send_json_success( [ 'html' => $html ] );

		}

		public function display_notices() {

			if(class_exists('WP_Dark_Mode_Ultimate')){
				return;
			}

			global $wp_dark_mode_license;

			if ( ! $wp_dark_mode_license->is_valid() ) {
				ob_start();
				wp_dark_mode()->get_template( 'admin/license-notice', [
					'plugin_name' => 'WP Dark Mode PRO',
					'version'     => WP_DARK_MODE_VERSION,
				] );
				$notice_html = ob_get_clean();

				wp_dark_mode_pro()->add_notice( 'warning notice-large is-dismissible', $notice_html );
			}
		}

		/**
		 * @return WP_Dark_Mode_Admin|null
		 */
		public static function instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

	}
}
WP_Dark_Mode_Admin::instance();