<?php
/**
 * @package BuddyBoss Child
 * The parent theme functions are located at /buddyboss-theme/inc/theme/functions.php
 * Add your own functions at the bottom of this file.
 */


/****************************** THEME SETUP ******************************/

/**
 * Sets up theme for translation
 *
 * @since BuddyBoss Child 1.0.0
 */
function buddyboss_theme_child_languages()
{
  /**
   * Makes child theme available for translation.
   * Translations can be added into the /languages/ directory.
   */

  // Translate text from the PARENT theme.
  load_theme_textdomain( 'buddyboss-theme', get_stylesheet_directory() . '/languages' );

  // Translate text from the CHILD theme only.
  // Change 'buddyboss-theme' instances in all child theme files to 'buddyboss-theme-child'.
  // load_theme_textdomain( 'buddyboss-theme-child', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'buddyboss_theme_child_languages' );

/**
 * Enqueues scripts and styles for child theme front-end.
 *
 * @since Boss Child Theme  1.0.0
 */
function buddyboss_theme_child_scripts_styles()
{
  /**
   * Scripts and Styles loaded by the parent theme can be unloaded if needed
   * using wp_deregister_script or wp_deregister_style.
   *
   * See the WordPress Codex for more information about those functions:
   * http://codex.wordpress.org/Function_Reference/wp_deregister_script
   * http://codex.wordpress.org/Function_Reference/wp_deregister_style
   **/

  // Styles
  wp_enqueue_style( 'buddyboss-child-css', get_stylesheet_directory_uri().'/assets/css/custom.css', '', '1.0.0' );

  // Light style
  wp_enqueue_style( 'buddyboss-child-light-css', get_stylesheet_directory_uri().'/assets/css/custom-light.css', '', '1.0.0');

  // Javascript
  wp_enqueue_script( 'buddyboss-child-js', get_stylesheet_directory_uri().'/assets/js/custom.js', '', '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'buddyboss_theme_child_scripts_styles', 9999 );

add_action( 'wp_enqueue_scripts', 'my_lazyload_assets', 10 );
function my_lazyload_assets() {
  $js_dir = get_stylesheet_directory_uri() . '/assets/js/';
  wp_enqueue_script( 'my-lazyload', $js_dir . 'lazyload.js', [], '', true );
}

/****************************** CUSTOM FUNCTIONS ******************************/

// Add your own custom functions here

add_filter( 'show_admin_bar' , 'my_function_admin_bar');
function my_function_admin_bar($show_admin_bar) {
    return ( current_user_can( 'administrator' ) ) ? $show_admin_bar : false;
}


/**
 *
 */
function add_custom_bp_tabs() {
    global $bp;
    $rolename = coinscout_current_user_role_fun();
    $roleslist = array('administrator','editor','author','contributor');
    
    if (in_array($rolename, $roleslist)){
        bp_core_new_subnav_item(array(
            'name' => 'Add New Token',
            'slug' => 'add-new-token',
            'parent_url' => trailingslashit(bp_displayed_user_domain() . 'listings'),
            'parent_slug' => 'listings',
            'screen_function' => 'create_group_redir',
            'position' =>150,
            'user_has_access' => bp_is_my_profile(),
            'link' => home_url().'/add-listing/'
            //'link' => trailingslashit( network_site_url() . '/gruppen/create');

        ));
    }
}

add_action( 'bp_setup_nav', 'add_custom_bp_tabs', 240 );

function create_group_redir() {
    add_action( 'bp_template_content', 'profile_screen_article_form_show' );
    bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/plugins' ) );

}
function profile_screen_article_form_show() {

    $html.="";
    $html.= do_shortcode('[gd_add_listing listing_type=gd_newsoutlet login_msg="Please register and login to submit listings" show_login=true]');
    $html.='</div>';
    echo $html;

    //locate_template( array( ‘feedback-profile.php’ ), true );

}
function coinscout_current_user_role_fun(){
    $user_id = get_current_user_id();
    if(isset($user_id) && !empty($user_id)){
        $user_meta=get_userdata($user_id);
        $user_roles = $user_meta->roles;
        return $user_roles['0'];
    }else{
        return true;
    }

 } 
 
 
add_filter( 'body_class','new_body_classes' );

function new_body_classes( $classes ) {
 	$rolename = coinscout_current_user_role_fun();
    $roleslist = array('administrator','editor','author','contributor');
    
 	if(is_admin() && is_user_logged_in()){
 		$classes[] = 'admin-login';
 	} else{
 		$classes[] = 'non-admin-login '.$rolename;
 	}
     
    return $classes;
     
}



/**
 * Register our sidebars and widgetized areas.
 *
 */
function arphabet_widgets_init() {

	register_sidebar( array(
		'name'          => 'Token Page Sidebar',
		'id'            => 'token_page_sidebar',
		'before_widget' => '<div>',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="rounded">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => 'Hashtag Sidebar',
		'id'            => 'hashtag_page_sidebar',
		'before_widget' => '<div>',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="rounded">',
		'after_title'   => '</h2>',
	) );
    
//     	register_sidebar( array(
// 		'name'          => 'Notification Left Sidebar',
// 		'id'            => 'notification_page_left_sidebar',
// 		'before_widget' => '<div>',
// 		'after_widget'  => '</div>',
// 		'before_title'  => '<h2 class="rounded">',
// 		'after_title'   => '</h2>',
// 	) );
	
	
// 		register_sidebar( array(
// 		'name'          => 'Sidebar 3',
// 		'id'            => 'sidebar_3',
// 		'before_widget' => '<div>',
// 		'after_widget'  => '</div>',
// 		'before_title'  => '<h2 class="rounded">',
// 		'after_title'   => '</h2>',
// 	) );
}
add_action( 'widgets_init', 'arphabet_widgets_init' );


add_action('publish_gd_token', 'send_notification',90, 2);
add_action('edit_gd_token', 'send_notification',90, 2);

function send_notification($post_id, $post_obj){
    global $wpdb;
  //  echo "test==>".$post_id.'===>'.$wpdb->prefix.'posts';

    //Assemble the message
    $table_name =$wpdb->prefix.'posts';
    if(isset($post_id)){
        
        $token_address  = geodir_get_post_meta($post_id,'token_contract',true);
    
         $ids =   $wpdb->update( 
                $table_name, 
                array( 
                    'post_name' =>$token_address
                ), 
                array( 'ID' =>$post_id,'post_type'=>'gd_token'), 
                array('%s'
                ), 
                array( '%d','%s') 
            );
           
            
     
    }
    
}
add_shortcode('favourite_token_post','favourite_token_post');

function favourite_token_post(){
    $user_id = get_current_user_id();
    $shortcode = do_shortcode('[user_favorites user_id="'.$user_id.'" post_types="gd_token"]');
    return $shortcode;
}

/**
 * Filter Moderation button for activity/comment.
 *
 * @param string $button button markup.
 * @param array  $args args.
 *
 * @return string
 */
function bpmts_custom_button_filter( $button, $args ) {

    if ( ! isset( $args['item_type'] ) || ! in_array( $args['item_type'], array( 'bp_activity', 'bp_acomment' ) ) ) {
        return $button;
    }
    $label =  __( 'Flag', 'buddypress-moderation-tools' );

    $use_bp_button_markup = $args['use_wrapper'];
    $wrapper_tag          = $args['wrapper_tag'];
    ob_start();
// data-bp-tooltip="Flag"
    ?>
    <div class='generic-button'> <a href="#" data-item-id="<?php echo esc_attr( $args['item_id'] ); ?>"
    
       data-item-type="<?php echo esc_attr( $args['item_type'] ); ?>"
       data-context="<?php echo esc_attr( $args['context'] ); ?>"
       data-context-id="<?php echo esc_attr( $args['context_id'] ); ?>"
      
       class="bpmts-report-button button item-button bp-secondary-action <?php echo $args['link_class']; ?>"> <i class="far fa-flag"></i>
<span><?php echo $label; ?></span></a> </div>

    <?php
    $button = ob_get_clean();
    if ( $use_bp_button_markup ) {
        $button = "<div class='generic-button'><div class=''><{$wrapper_tag} class='bpmts-moderation-button-wrap bpmts-type-{$args['item_type']}-button generic-button {$args['wrapper_class']}'>{$button}</{$wrapper_tag}></div></div>";
    }

    return $button;
}

add_filter( 'bpmts_report_button', 'bpmts_custom_button_filter', 99,2);

add_filter( 'bp_xprofile_is_richtext_enabled_for_field', 'my_disable_rt_function', 10, 2 );
function my_disable_rt_function( $enabled, $field_id ) {
  // 14 is the id of the field I want to be plain text.
  if ( 30 == $field_id ) {
    $enabled = false;
  }
  return $enabled;
}

remove_feed('rss');

function remove_feed( $feedname ) {
    global $wp_rewrite;
    
    // $wp_rewrite->feed_base ='rss';
    // // print_r($wp_rewrite);
    // // die;

    if ( in_array( $feedname, $wp_rewrite->feeds ) ) {
            $wp_rewrite->feeds = array_diff( $wp_rewrite->feeds, array( $feedname ) );
    }

    $hook = 'do_feed_' . $feedname;

    // Remove default function hook
   remove_all_actions( $hook );
 add_action( $hook, $hook );

    return $wp_rewrite;
}

//add_action( 'init','remove_feed');

// function feed_rewrite_1( $wp_rewrite ) {

//     $feed_rules = array(
//         'feed/portfolio'    =>  'index.php?post_type=post&feed=rss2'
//     );

//     $wp_rewrite->rules = $feed_rules + $wp_rewrite->rules;
// }

//remove_rewrite_tag('feed');


//add_filter( 'the_content', 'my_lazyload_content_images' );
//add_filter( 'widget_text', 'my_lazyload_content_images' );
//add_filter( 'wp_get_attachment_image_attributes', 'my_lazyload_attachments', 10, 2 );

// Replace the image attributes in Post/Page Content
function my_lazyload_content_images( $content ) {
  $content = preg_replace( '/(<img.+)(src)/Ui', '$1data-$2', $content );
  $content = preg_replace( '/(<img.+)(srcset)/Ui', '$1data-$2', $content );
  return $content;
}

// Replace the image attributes in Post Listing, Related Posts, etc.
function my_lazyload_attachments( $atts, $attachment ) {
  $atts['data-src'] = $atts['src'];
  unset( $atts['src'] );
  
  if( isset( $atts['srcset'] ) ) {
    $atts['data-srcset'] = $atts['srcset'];
    unset( $atts['srcset'] );
  }

  return $atts;
}


/*
 * The bp_is_active( 'groups' ) check is recommended, to prevent problems
 * during upgrade or when the Groups component is disabled
 */
if(is_user_logged_in()):

  if ( bp_is_active( 'groups' ) ) :
  
    class Group_Extension_Example extends BP_Group_Extension {
      /**
       * Here you can see more customization of the config options
       */
      function __construct() {
        $args = array(
          'slug' => 'tokens',
          'name' => 'Token Data',
          'nav_item_position' => 105,
          'visibility' =>'public',
          'access' =>'anyone',
          'screens' => array(
            'edit' => array(
              'name' => 'Token Data',
              'slug' => 'token-data',
              'submit_text' => 'Token Data', // Changes the text of the Submit button on the Edit page
            ),
            'create' => array(
              'position' => 100,
            ),
          ),
        );
        parent::init( $args );
      }
    
      function display( $group_id = NULL ) {

        $group_id = bp_get_group_id();
        
      
        
        $design_style = geodir_design_style();
       // echo "===>".$design_style;
        $design_style = geodir_design_style();
        $template = $design_style ? $design_style."/single/tabs.php" : "legacy/single/tabs.php";
        $slug = 'geodirectory/'.$template;
        $post_id = groups_get_groupmeta( $group_id, $meta_key ='post_id');
       //echo "===>".$post_id;
        echo customTabs($post_id);
        echo do_shortcode('[gd_single_tabs]');
       
       

      }
    
      function settings_screen( $group_id = NULL ) {
        $setting = groups_get_groupmeta( $group_id, 'review_setting' );
    
        ?>
        
        Save your plugin setting here: <input type="text" name="review_setting" value="" />
        
        Welcome to your new group! You are neat.
        Save your plugin setting here: <input type="text" name="review_setting" value="" />
        <?php
      }
    
    }
  //  bp_register_group_extension( 'Group_Extension_Example' );
    
    endif;
  
  endif;


  /**
 * Register our sidebars and widgetized areas.
 *
 */
function save_token_page() {

	register_sidebar( array(
		'name'          => 'Token watchlist',
		'id'            => 'token_watchlist',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '<h2 class="rounded">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'save_token_page' );

