<?php
/**
 * Assets Loader
 *
 * @package    ReportAbuse
 * @subpackage Bootstrap
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Bootstrap;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 0 );
}

/**
 * Assets Loader.
 */
class Assets_Loader {

	/**
	 * Data to be send as localized js.
	 *
	 * @var array
	 */
	private $data = array();

	/**
	 * Boot it.
	 */
	public static function boot() {
		$self = new self();
		add_action( 'wp_enqueue_scripts', array( $self, 'register' ) );
		add_action( 'wp_enqueue_scripts', array( $self, 'enqueue' ) );
		add_action( 'wp_footer', array( $self, 'load_popup_template' ) );

		add_action( 'admin_print_styles-toplevel_page_bpmts-moderation', array( $self, 'admin_enqueue_styles' ) );
		add_action( 'admin_print_styles-moderation_page_bpmts-log', array( $self, 'admin_enqueue_styles' ) );
		add_action( 'admin_print_styles-moderation_page_bpmts-category', array( $self, 'admin_enqueue_styles' ) );
	}
	/**
	 * Register assets.
	 */
	public function register() {
		$this->register_vendors();
		$this->register_core();
	}

	/**
	 * Load assets.
	 */
	public function enqueue() {
		wp_enqueue_style( 'pt-report-abuse' );
		wp_enqueue_script( 'pt-report-abuse' );
		wp_localize_script( 'pt-report-abuse', 'PTReportAbuse', $this->data );
	}

	/**
	 * Register vendor scripts.
	 */
	private function register_vendors() {
		$bpmts      = bpmts_moderation_tools();
		$url     = $bpmts->url;
		$version = $bpmts->version;

		wp_register_style( 'ggpopover', $url . 'assets/css/ggpopover.min.css', false, $version );
		wp_register_script( 'ggpopover', $url . 'assets/js/ggpopover.js', array( 'jquery' ), $version );

		wp_register_script( 'jquery-cookie', $url . 'assets/js/jquery-cookie.js', array( 'jquery' ) );
	}

	/**
	 * Register core assets.
	 */
	private function register_core() {
		$bpmts      = bpmts_moderation_tools();
		$url     = $bpmts->url;
		$version = $bpmts->version;

		wp_register_style( 'pt-report-abuse', $url . 'assets/css/report-abuse.css', array( 'ggpopover' ), $version );

		$dep = array( 'ggpopover' );

		if ( ! wp_script_is( 'bp-jquery-cookie' ) ) {
			$dep[] = 'jquery-cookie';
		} else {
			$dep[] = 'bp-jquery-cookie';
		}

		wp_register_script( 'pt-report-abuse', $url . 'assets/js/report-abuse.js', $dep, $version );

		$this->data['nonce']     = wp_create_nonce( 'wp_rest' );
		$this->data['formTitle'] = __( 'Report', 'buddypress-moderation-tools' );
		$this->data['isLogged']  = is_user_logged_in();

		$this->data['messages'] = array(
			'subjectRequired' => __( 'Subject is required!', 'buddypress-moderation-tools' ),
			'messageRequired' => __( 'Message is required!', 'buddypress-moderation-tools' ),
			'messageReporting' => __( 'Reporting...', 'buddypress-moderation-tools' ),
			'alreadyReported' => __( 'You have already reported it!', 'buddypress-moderation-tools' ),
		);
		$this->data['required'] = bpmts_get_option( 'required_form_fields', array() );
	}

	/**
	 * Add to template.
	 */
	public function load_popup_template() {
		if ( ! bpmts_user_can_report() ) {
			return;
		}
		?>
		<script type="text/template" id="bpmts_form_template">
			<?php require_once bpmts_moderation_tools()->path . 'assets/template/popup.php'; ?>
		</script>
		<?php
	}

	/**
	 * Load admin css.
	 */
	public function admin_enqueue_styles() {

		$bpmts      = bpmts_moderation_tools();
		$url     = $bpmts->url;
		$version = $bpmts->version;

		wp_register_style( 'bpmts-admin', $url . 'src/admin/assets/css/bpmts-admin.css', null, $version );
		wp_enqueue_style( 'bpmts-admin' );

	}
}
