<?php
/**
 * Model class for moderation log table
 *
 * @package buddypress-moderation-tools
 */

namespace PressThemes\ModerationTools\Models;

use PressThemes\ModerationTools\Schema\Schema;

/**
 * Class Log
 *
 * @property-read int $id             Row id.
 * @property-read int $queue_id       Queue id.
 * @property-read int $moderator_id   User id.
 * @property-read string $message     User message.
 * @property-read string $action      User action.
 * @property-read string $created_at Moderation date
 * @property-read string $updated_at Moderation date
 */
class Log extends Model {

	/**
	 * Get the table name.
	 *
	 * @return string
	 */
	public static function table() {
		return Schema::table( 'log' );
	}

	/**
	 * Get table schema.
	 *
	 * @return array
	 */
	public static function schema() {

		return array(
			'id'           => 'integer',
			'queue_id'     => 'integer',
			'moderator_id' => 'integer',
			'message'      => 'string',
			'action'       => 'string',
			'created_at'   => 'datetime',
			'updated_at'   => 'datetime',
		);
	}
}
