<?php
/**
 * Admin Settings Pages for the Forum.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BBPress\Topic
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress\Topic\Admin;

use Press_Themes\PT_Settings\Panel;

// Exit if the file is accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Topic_Settings_Panel {

	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$defaults = bpmts_get_default_settings();

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/topic-moderation-settings/';
		$panel->add_section( 'report-topic-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
			  ->add_field(
				  array(
					  'name'    => 'bbp_topic_auto_hide',
					  'label'   => __( 'Auto hide topic?', 'buddypress-moderation-tools' ),
					  'type'    => 'radio',
					  'default' => $defaults['bbp_topic_auto_hide'],
					  'options' => array(
						  1 => __( 'Yes', 'buddypress-moderation-tools' ),
						  0 => __( 'No', 'buddypress-moderation-tools' ),
					  ),
					  'desc'    => __( 'If enabled, reported topics will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
				  ) )
			  ->add_field(
				  array(
					  'name'    => 'bbp_topic_threshold',
					  'label'   => __( 'Topic hiding threshold ', 'buddypress-moderation-tools' ),
					  'type'    => 'number',
					  'default' => $defaults['bbp_topic_threshold'],
					  'desc'    => __( 'How many users should report the topic before it gets hidden?', 'buddypress-moderation-tools' ),
				  )
			  )
			  ->add_field(
				  array(
					  'name'    => 'bbp_topic_hide_type',
					  'label'   => __( 'Hide topic for', 'buddypress-moderation-tools' ),
					  'type'    => 'multicheck',
					  'default' => $defaults['bbp_topic_hide_type'],
					  'options' => array(
						  'all'      => __( 'All when threshold is reached.', 'buddypress-moderation-tools' ),
						  'reporter' => __( 'Reporters when they report the topic', 'buddypress-moderation-tools' ),
					  ),
					  'desc'    => __( 'Enable auto hiding of topic for the reporters or all users when threshold is reached.', 'buddypress-moderation-tools' ),
				  )
			  );

		// Notification.
		$section = $panel->add_section( 'report-topic-new-report-admin-notification', __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field(
			array(
				'name'    => 'bbp_topic_notify_admin_on_report',
				'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
				'type'    => 'radio',
				'default' => $defaults['bbp_topic_notify_admin_on_report'],
				'options' => array(
					1 => __( 'Yes', 'buddypress-moderation-tools' ),
					0 => __( 'No', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'Notify admin if a topic is reported.', 'buddypress-moderation-tools' ),
			)
		);

		$section->add_field(
			array(
				'name'    => 'bbp_topic_admin_reported_subject',
				'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bbp_topic_admin_reported_subject'],
			)
		)->add_field(
			array(
				'name'    => 'bbp_topic_admin_reported_message',
				'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bbp_topic_admin_reported_message'],
			)
		);

		// Notification.
		$section = $panel->add_section( 'report-topic-admin-threshold-notification', __( 'Admin notification on hiding topic', 'buddypress-moderation-tools' ) );

		$section->add_field(
			array(
				'name'    => 'bbp_topic_notify_admin_on_hide',
				'label'   => __( 'Notify admin when a topic is hidden?', 'buddypress-moderation-tools' ),
				'type'    => 'radio',
				'default' => $defaults['bbp_topic_notify_admin_on_hide'],
				'options' => array(
					1 => __( 'Yes', 'buddypress-moderation-tools' ),
					0 => __( 'No', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'Admin will only be notified when a topic is hidden.', 'buddypress-moderation-tools' ),
			)
		);

		$section->add_field(
			array(
				'name'    => 'bbp_topic_admin_hidden_subject',
				'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bbp_topic_admin_hidden_subject'],
			)
		)->add_field(
			array(
				'name'    => 'bbp_topic_admin_hidden_message',
				'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bbp_topic_admin_hidden_message'],
			)
		);

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'report-topic-user-threshold-notification', __( 'User notification on hiding topic', 'buddypress-moderation-tools' ) );

		$section->add_field(
			array(
				'name'    => 'bbp_topic_notify_user_on_hide',
				'label'   => __( 'Notify topic creator when their topic is hidden?', 'buddypress-moderation-tools' ),
				'type'    => 'radio',
				'default' => $defaults['bbp_topic_notify_user_on_hide'],
				'options' => array(
					1 => __( 'Yes', 'buddypress-moderation-tools' ),
					0 => __( 'No', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'User will be notified when their topic is hidden.', 'buddypress-moderation-tools' ),
			)
		);

		$section->add_field(
			array(
				'name'    => 'bbp_topic_user_hidden_subject',
				'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bbp_topic_user_hidden_subject'],
			)
		)->add_field(
			array(
				'name'    => 'bbp_topic_user_hidden_message',
				'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bbp_topic_user_hidden_message'],
			)
		);

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-topic-user-notification-activity-restore', __( 'User notification on topic restoration', 'buddypress-moderation-tools' ) );

		$section->add_field(
			array(
				'name'    => 'bbp_topic_notify_user_on_restore',
				'label'   => __( 'Notify topic creator when their topic is restored?', 'buddypress-moderation-tools' ),
				'type'    => 'radio',
				'default' => $defaults['bbp_topic_notify_user_on_restore'],
				'options' => array(
					1 => __( 'Yes', 'buddypress-moderation-tools' ),
					0 => __( 'No', 'buddypress-moderation-tools' ),
				),
				'desc'    => __( 'topic creator will be notified when their topic is restored.', 'buddypress-moderation-tools' ),
			)
		);

		$section->add_field(
			array(
				'name'    => 'bbp_topic_user_restored_subject',
				'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bbp_topic_user_restored_subject'],
			)
		)->add_field(
			array(
				'name'    => 'bbp_topic_user_restored_message',
				'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bbp_topic_user_restored_message'],
			)
		);


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-topic-notification-topic-delete', __( 'User notification on topic delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_topic_notify_user_on_delete',
			'label'   => __( 'Notify user when their topic is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_topic_notify_user_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their topic is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_topic_user_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_topic_user_deleted_subject'],
		) )->add_field( array(
			'name'    => 'bbp_topic_user_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_topic_user_deleted_message'],
		) );
	}
}