<?php
/**
 * BuddyPress Moderation Tools:- Activity UI Helper.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Activity
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity\Handlers;

// Exit if files accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Buttons & Messages management.
 */
class Activity_UI_Helper {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// filter body.
		if ( is_super_admin() ) {
			add_filter( 'body_class', array( $this, 'add_body_class' ) );
			add_filter( 'bp_get_activity_css_class', array( $this, 'add_entry_class' ) );
		}

		// Add Buttons.
		add_action( 'bp_activity_entry_meta', array( $this, 'add_button' ), 1001 );
		// in case of activity, 'bp_activity_entry_meta' is only called for logged in.
		add_action( 'bp_activity_entry_content', array( $this, 'add_non_logged_button' ), 1001 );
	}


	/**
	 * Add appropriate class to body.
	 *
	 * @param array $classes css classes.
	 *
	 * @return array
	 */
	public function add_body_class( $classes ) {

		if ( bp_is_single_activity() ) {
			$classes[] = bpmts_is_activity_hidden( bp_get_activity_permalink_id(), true ) ? 'bpmts-displayed-item-hidden bpmts-displayed-activity-hidden' : 'bpmts-displayed-item-clean bpmts-displayed-activity-clean';
		}

		return $classes;
	}
	
	/**
	 * Add appropriate class to activity entry
	 *
	 * @param array $classes css classes.
	 *
	 * @return string
	 */
	public function add_entry_class( $classes ) {

		if ( bpmts_is_activity_hidden( bp_get_activity_id(), true ) ) {
			$classes .= ' bpmts-item-entry-hidden bpmts-activity-entry-hidden';
		} else {
			$classes .= ' bpmts-item-entry-clean bpmts-activity-entry-clean';
		}

		return $classes;
	}

	/**
	 * Add button to activity entry(It only works for logged in members).
	 */
	public function add_button() {
		if ( is_user_logged_in() && bpmts_is_me( bp_get_activity_user_id() ) ) {
			return;
		}

		if ( bpmts_user_can_report() ) {
			bpmts_report_button( array(
				'item_id'     => bp_get_activity_id(),
				'item_type'   => 'bp_activity',
				'context'     => bp_get_activity_object_name(),
				'context_id'  => bp_get_activity_item_id(),
				'use_wrapper' => false,
				'link_class'  => 'button item-button bp-secondary-action bpmts-activity-report-button',
			) );
		}
	}

	/**
	 * Add button for non logged in user.
	 */
	public function add_non_logged_button() {

		if ( ! is_user_logged_in() && bpmts_user_can_report() ) {
			echo "<div class='activity-meta bpmts-activity-meta'>";
			bpmts_report_button( array(
				'item_id'    => bp_get_activity_id(),
				'item_type'  => 'bp_activity',
				'context'    => bp_get_activity_object_name(),
				'context_id' => bp_get_activity_item_id(),
				'link_class' => 'button item-button bp-secondary-action bpmts-activity-report-button',
			) );
			echo '</div>';
		}
	}
}
