<?php
/**
 * BuddyPress Moderation Tools:- Group UI Helper.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Group
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Group\Handlers;

// Exit if files accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Group_UI_Helper
 *
 * Buttons & Messages management.
 */
class Group_UI_Helper {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// filter body.
		if ( is_user_logged_in() && is_super_admin() ) {
			add_filter( 'body_class', array( $this, 'add_body_class' ) );
			add_filter( 'bp_get_group_class', array( $this, 'add_list_class' ) );
		}

		// Add Buttons.
		add_action( 'bp_group_header_actions', array( $this, 'single_group_button' ), 1001 );
		add_action( 'bp_directory_groups_actions', array( $this, 'groups_loop_button' ), 1001 );
	}

	/**
	 * Add appropriate class to body.
	 *
	 * @param array $classes css classes.
	 *
	 * @return array
	 */
	public function add_body_class( $classes ) {

		if ( ! is_user_logged_in() || ! function_exists( 'buddypress' ) ) {
			return $classes;
		}

		if ( bp_is_group() ) {
			$classes[] = bpmts_is_group_hidden( bp_get_current_group_id() ) ? 'bpmts-displayed-item-hidden bpmts-displayed-group-hidden' : 'bpmts-displayed-item-clean bpmts-displayed-group-clean';
		}

		return $classes;
	}

	/**
	 * Add extra class to member list entry.
	 *
	 * @param array $classes classes.
	 *
	 * @return array
	 */
	public function add_list_class( $classes ) {
		$classes[] = bpmts_is_group_hidden( bp_get_group_id(), true ) ? 'bpmts-item-entry-hidden bpmts-group-entry-group-hidden' : 'bpmts-item-entry-clean bpmts-group-entry-group-clean';

		return $classes;
	}

	/**
	 * Add button to single member header.
	 */
	public function single_group_button() {

		if ( bpmts_user_can_report() ) {
			bpmts_report_button( array(
				'item_id'    => bp_get_current_group_id(),
				'item_type'  => 'bp_group',
				'context'    => 'bp_group_header',
				'context_id' => bp_get_current_group_id(),
			) );
		}
	}

	/**
	 * Member loop button.
	 */
	public function groups_loop_button() {
		global $groups_template;

		$group = & $groups_template->group;

		if ( bpmts_user_can_report() ) {
			bpmts_report_button( array(
				'item_id'    => $group->id,
				'item_type'  => 'bp_group',
				'context'    => 'bp_groups_list',
				'context_id' => $group->id,
			) );
		}
	}
}
