<?php
/**
 * BuddyPress Moderation Tools:- Group Message Builder.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Group
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Group\Messages;

use PressThemes\ModerationTools\Messages\Message_Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Group message builder.
 */
class Group_Message_Builder extends Message_Builder {

	/**
	 * Token map.
	 *
	 * @param \BP_Groups_Group $item item.
	 *
	 * @return array
	 */
	public function item_tokens_map( $item ) {
		return array(
			'{item.type}' => __( 'group', 'buddypress-moderation-tools' ),
			'{item.label}' => $item->name,
			'{item.url}'   => bp_get_group_permalink( $item ),
		);
	}
}

