<?php
/**
 * ReportAbuse:- Post Type Builder.
 *
 * @package    ModerationTools
 * @subpackage Reportable_Types\Comment_Type\Messages
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Comment_Type\Messages;

use PressThemes\ModerationTools\Messages\Message_Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Comment Type message builder.
 */
class Comment_Type_Message_Builder extends Message_Builder {

	/**
	 * Token map.
	 *
	 * @param \WP_Comment $item item.
	 *
	 * @return array
	 */
	public function item_tokens_map( $item ) {

		if ( ! $item ) {
			return array();
		}

		return array(
			'{item.type}'  => $item->comment_type,
			'{item.author}' => $item->comment_author,
			'{item.url}'   => get_comment_link( $item->comment_ID ),
		);
	}
}

