<?php
/**
 * MediaPress media Type support.
 *
 * @package    ReportAbuse
 * @subpackage Reportable
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\MediaPress;

use PressThemes\ModerationTools\Reportable_Types\Reportable_Item_Type;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ReportableBuddyPress Activity
 */
class Reportable_Type_MPP_Media extends Reportable_Item_Type {

	/**
	 * Reportable_BP_Activity constructor.
	 */
	public function __construct() {
		parent::__construct( 'mpp-media', __( 'MediaPress Media', 'buddypress-moderation-tools' ) );
	}

	/**
	 * Check that media exists.
	 *
	 * @param int    $item_id post id.
	 * @param string $context ignore.
	 * @param int    $context_id ignore.
	 *
	 * @return bool
	 */
	public function is_valid( $item_id, $context, $context_id ) {
		$media = mpp_get_media( $item_id );
		return $media && $media->id;
	}


	/**
	 * Delete an item of this type.
	 *
	 * @param int $item_id item id.
	 */
	public function delete( $item_id ) {
		mpp_delete_media( $item_id );
	}

	/**
	 * Get the item object.
	 *
	 * @param int $item_id user id.
	 *
	 * @return false|\MPP_Media
	 */
	public function get_item( $item_id ) {
		return mpp_get_media( $item_id );
	}

	/**
	 * Get the thumbnail
	 *
	 * @param int    $item_id item id.
	 * @param string $size thumb|full.
	 *
	 * @return string
	 */
	public function get_item_thumbnail( $item_id, $size ) {
		return mpp_get_media_src( $size, $item_id );
	}

	/**
	 * Get item title.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_title( $item_id ) {
		return mpp_get_media_title( $item_id );
	}

	/**
	 * Get item description.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_description( $item_id ) {
		return mpp_get_media_description( $item_id );
	}

	/**
	 * Get Post Permalink.
	 *
	 * @param int $item_id user id.
	 *
	 * @return false|string
	 */
	public function get_item_permalink( $item_id ) {
		return mpp_get_media_permalink( $item_id );
	}

	/**
	 * Get item edit url.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_edit_url( $item_id ) {
		return mpp_get_media_edit_url( $item_id );
	}

	/**
	 * Get item delete url.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_delete_url( $item_id ) {
		return mpp_get_media_delete_url( $item_id );
	}
}
