<?php
/**
 * Post Type UI Helper.
 *
 * @package    BuddyPressModerationTools
 * @subpackage Post_TYpe
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Post_Type\Handlers;

// Exit if files access directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Buttons & Messages management.
 */
class Post_Type_UI_Helper {

	/**
	 * Post type.
	 *
	 * @var string
	 */
	private $post_type = '';

	/**
	 * Boot this class.
	 *
	 * @param string $post_type post type.
	 */
	public static function boot( $post_type ) {
		$self            = new self();
		$self->post_type = $post_type;
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// filter body.
		if ( is_user_logged_in() && is_super_admin() ) {
			add_filter( 'body_class', array( $this, 'add_body_class' ) );
			add_filter( 'post_class', array( $this, 'add_list_class' ) );
		}

		// Add Buttons.
		add_action( 'the_content', array( $this, 'add_report_buttons' ), 1001 );
	}


	/**
	 * Add appropriate class to body.
	 *
	 * @param array $classes css classes.
	 *
	 * @return array
	 */
	public function add_body_class( $classes ) {

		if ( ! is_user_logged_in() ) {
			return $classes;
		}

		if ( is_singular( $this->post_type ) ) {
			$classes[] = bpmts_is_item_hidden( get_queried_object_id(), $this->post_type ) ? "bpmts-displayed-item-hidden bpmts-displayed-{$this->post_type}-hidden" : "bpmts-displayed-item-clean bpmts-displayed-{$this->post_type}-clean";
		}

		return $classes;
	}

	/**
	 * Add extra class to member list entry.
	 *
	 * @param array $classes classes.
	 *
	 * @return array
	 */
	public function add_list_class( $classes ) {
		$classes[] = bpmts_is_item_hidden( get_the_ID(), $this->post_type ) ? "bpmts-item-entry-hidden bpmts-post-type-entry-{$this->post_type}-hidden" : "bpmts-item-entry-clean bpmts-post-type-entry-{$this->post_type}-clean";

		return $classes;
	}

	/**
	 * Add button to single member header.
	 *
	 * @param string $content post content.
	 *
	 * @return string
	 */
	public function add_report_buttons( $content ) {

		if ( get_post_type() === $this->post_type && bpmts_user_can_report() ) {
			$content .= bpmts_get_report_button( array(
				'item_id'    => get_the_ID(),
				'item_type'  => $this->post_type,
				'context'    => $this->post_type,
				'context_id' => get_the_ID(),
			) );
		}

		return $content;
	}
}
