<?php
/**
 * Admin Settings Pages for the User.
 * @package    ReportAbuse
 * @subpackage Report_Types\User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\User\Admin;

// Exit if the file is accessed directly over web.
use Press_Themes\PT_Settings\Panel;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Message_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/settings-buddypress-private-message/';

		$defaults = array(
			'bp_message_enable_reporting'     => 1,
			'bp_message_block_peer_message'   => 1,
			'bp_message_blocked_peer_message' => __( ' There was a problem. Please try again later', 'buddypress-moderation-tools' ),
			'bp_message_auto_block'           => 1,
			'bp_message_threshold'            => 5,
			'bp_message_blocked_user_message' => __( ' There was a problem. Please try again later', 'buddypress-moderation-tools' ),
		);

		$panel->add_section( 'report-user-messages-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'bp_message_enable_reporting',
			      'label'   => __( 'Enable user reporting on message?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bp_message_enable_reporting'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, a user can report other users from message page.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bp_message_block_peer_message',
			      'label'   => __( 'Block reported users from sending new message to the reporter?', 'buddypress-moderation-tools' ),
			      'type'    => 'select',
			      'default' => $defaults['bp_message_block_peer_message'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'Should the reported user be blocked from sending new message to the user who reported them.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bp_message_blocked_peer_message',
			      'label'   => __( 'Peer blocked message', 'buddypress-moderation-tools' ),
			      'type'    => 'textarea',
			      'default' => $defaults['bp_message_blocked_peer_message'],
			      'desc'    => __( 'Message shown to the sender if they are blocked by the receiver.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bp_message_auto_block',
			      'label'   => __( 'Enable global block for the reported user?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bp_message_auto_block'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If yes, user will be blocked sitewide from sending message to any other user when the reach the threshold.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bp_message_threshold',
			      'label'   => __( 'Threshold to block sitewide.', 'buddypress-moderation-tools' ),
			      'type'    => 'number',
			      'default' => $defaults['bp_message_threshold'],
			      'desc'    => __( 'If reported these many times, the user will be blocked from sending new message.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bp_message_blocked_user_message',
			      'label'   => __( 'Message to be shown to the sitewide blocked user', 'buddypress-moderation-tools' ),
			      'type'    => 'textarea',
			      'default' => $defaults['bp_message_blocked_user_message'],
			      'desc'    => __( 'Notice shown to the user on site.', 'buddypress-moderation-tools' ),
		      ) );
	}
}
