<?php
/**
 * Admin Settings Paanel for the User.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\User\Admin;

// Exit if the file is accessed directly over web.
use Press_Themes\PT_Settings\Panel;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class User_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/user-reporting-settings/';
		$defaults = bpmts_get_default_settings();


		$panel->add_section( 'bpmts-user-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'user_auto_hide',
			      'label'   => __( 'Auto hide user?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['user_auto_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, reported users will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )->add_field( array(
			      'name'    => 'user_threshold',
			      'label'   => __( 'User hiding threshold ', 'buddypress-moderation-tools' ),
			      'type'    => 'number',
			      'default' => $defaults['user_threshold'],
			      'desc'    => __( 'How many users should report the user profile before it gets hidden?', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'user_hide_type',
			      'label'   => __( 'Hide user for', 'buddypress-moderation-tools' ),
			      'type'    => 'multicheck',
			      'default' => $defaults['user_hide_type'],
			      'options' => array(
				      'all'      => __( 'All when threshold is reached.', 'buddypress-moderation-tools' ),
				      'reporter' => __( 'Reporters when they report the user', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'Enable auto hiding of user for the reporters or all users when threshold is reached.', 'buddypress-moderation-tools' ),
		      ) ) ->add_field( array(
			      'name'    => 'user_logout_on_hide',
			      'label'   => __( 'Logout user on reaching threshold', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['user_logout_on_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
		              0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If yes, user will be logged out from all devices on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'user_disable_login',
			      'label'   => __( 'Block user login', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['user_disable_login'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'Disable user login if threshold is reached.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'user_disable_login_message',
			      'label'   => __( 'Blocked user login message', 'buddypress-moderation-tools' ),
			      'type'    => 'textarea',
			      'default' => $defaults['user_disable_login_message'],
			      'desc'    => __( 'Message shown on login if the login is disabled for user.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'user_hidden_user_message',
			      'label'   => __( 'Hidden user sitewide notice', 'buddypress-moderation-tools' ),
			      'type'    => 'textarea',
			      'default' => $defaults['user_hidden_user_message'],
			      'desc'    => __( 'Notice shown to the user on site.', 'buddypress-moderation-tools' ),
		      ))
			->add_field( array(
				'name'    => 'user_disable_private_message',
				'label'   => __( 'Disable private messages?', 'buddypress-moderation-tools' ),
				'type'    => 'checkbox',
				'default' => $defaults['user_disable_private_message'],
				'desc'    => __( 'Disable private messages on reaching threshold.', 'buddypress-moderation-tools' ),
			) )
			->add_field( array(
				'name'    => 'user_disable_activity_posting',
				'label'   => __( 'Disable activity update posting?', 'buddypress-moderation-tools' ),
				'type'    => 'checkbox',
				'default' => $defaults['user_disable_activity_posting'],
				'desc'    => __( 'Disable activity posting on reaching threshold.', 'buddypress-moderation-tools' ),
			) )
			->add_field( array(
				'name'    => 'user_disable_activity_commenting',
				'label'   => __( 'Disable activity commenting?', 'buddypress-moderation-tools' ),
				'type'    => 'checkbox',
				'default' => $defaults['user_disable_activity_commenting'],
				'desc'    => __( 'Disable activity commenting on reaching threshold.', 'buddypress-moderation-tools' ),
			) );

		// Notification.
		$section = $panel->add_section( 'bpmts-user-new-report-admin-notification', __( 'Admin New Report Notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'user_notify_admin_on_report',
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['user_notify_admin_on_report'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Notify admin if a user is reported.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'user_admin_new_report_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['user_admin_new_report_subject'],
		) )->add_field( array(
			'name'    => 'user_admin_new_report_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'textarea',
			'default' => $defaults['user_admin_new_report_message'],
		) );

		// Notification.
		$section = $panel->add_section( 'bpmts-user-admin-threshold-notification', __( 'Admin Notification on Hiding User', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'user_notify_admin_on_hide',
			'label'   => __( 'Notify admin when user is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['user_notify_admin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Admin will be notified when a user profile is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'user_admin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['user_admin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'user_admin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'textarea',
			'default' => $defaults['user_admin_hidden_message'],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'bpmts-user-user-threshold-notification', __( 'User Notification on Hiding profile', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'user_notify_user_on_hide',
			'label'   => __( 'Notify user when their profile is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['user_notify_user_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their profile is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'user_user_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['user_user_hidden_subject'],
		) )->add_field( array(
			'name'    => 'user_user_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['user_user_hidden_message'],
		));

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'bpmts-user-user-notification-user-restore', __( 'User Notification on profile restore', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'user_notify_user_on_restore',
			'label'   => __( 'Notify user when their profile is restored?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['user_notify_user_on_restore'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their profile is restored.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'user_user_restored_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['user_user_restored_subject'],
		) )->add_field( array(
			'name'    => 'user_user_restored_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['user_user_restored_message'],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'bpmts-user-user-notification-user-delete', __( 'User Notification on profile delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'user_notify_user_on_delete',
			'label'   => __( 'Notify user when their profile is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['user_notify_user_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their profile is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'user_user_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['user_user_deleted_subject'],
		) )->add_field( array(
			'name'    => 'user_user_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['user_user_deleted_message'],
		) );
	}
}
