<?php
/**
 * BuddyPress Moderation Tools:- User Gate.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\User\Gate;


// Exit if files accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Action handler.
 */
class User_Gate {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// login check.
		add_action( 'wp_login', array( $this, 'check_login' ), 10, 2 );
	}

	/**
	 * On user login, may be restrict if needed.
	 *
	 * @param string $user_login user_name.
	 * @param object $user WP_User class.
	 */
	public function check_login( $user_login, $user ) {

		// Do not do anything if login is not blocked.
		if ( ! bpmts_get_option( 'user_disable_login' ) ) {
			return ;
		}

		if ( ! $user ) {
			$user = get_user_by( 'login', $user_login );
		}

		// do not restrict super admins. No denial of service.
		if ( ! $user || is_super_admin( $user->ID ) ) {
			return;
		}

		if ( bpmts_is_user_hidden( $user->ID ) ) {
			// Clear auth cookie.
			wp_clear_auth_cookie();

			/**
			 * See the login_blocked_message() to see how the bpmts_blocked is being used.
			 *
			 * @see User_UI_Helper::login_blocked_message()
			 */
			$login_url = add_query_arg( 'bpmts_blocked', 1, wp_login_url() );
			wp_safe_redirect( $login_url );
			exit;
		}
	}

}
