<?php
/**
 * BuddyPress Moderation Tools:- User Message Gate.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\User\Gate;


// Exit if files accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles restrictions on activity/activity comment posting.
 */
class User_Message_Gate {
	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		if ( ! bpmts_get_option( 'user_disable_private_message' ) ) {
			return;
		}
		// 1. remove compose nav
		// 2. hide all pm buttons
		// hide reply button.
		// hide reply box.
		// compose
		add_filter( 'bp_get_send_message_button', array( $this, 'hide_send_message_button' ) );
		// Put a gateway for sending message.
		add_action( 'wp_ajax_messages_send_reply', array( $this, 'check_if_reply_allowed' ), 2 );

		add_action( 'bp_template_redirect', array( $this, 'gateway' ), 3 );
		add_action( 'bp_template_redirect', array( $this, 'maybe_remove_compose' ) );
	}

	public function maybe_remove_compose() {
		if ( is_super_admin() || ! bpmts_is_loggedin_user_hidden() ) {
			return;
		}

		bp_core_remove_subnav_item( 'messages', 'compose' );
	}

	/**
	 * Check and block message sending.
	 */
	public function gateway() {

		// Bail if not posting to the compose message screen.
		if (  ! bp_is_messages_component() || ! bp_is_current_action( 'compose' ) ) {
			return false;
		}

		if ( is_super_admin() || ! bpmts_is_loggedin_user_hidden() ) {
			return;
		}

		bp_core_add_message( __( 'Action not allowed.', 'buddypress-moderation-tools' ), 'error' );
		bp_core_redirect( trailingslashit( bp_loggedin_user_domain() . bp_get_messages_slug() ) );
	}
	/**
	 * Hide Send Message button
	 *
	 * @param string $btn button html.
	 *
	 * @return string
	 */
	public function hide_send_message_button( $btn ) {

		// super admins can send message to anyone.
		if ( is_super_admin() || ! bpmts_is_loggedin_user_hidden() ) {
			return $btn;
		}

		return '';
	}

	/**
	 * Check if reply is allowed
	 */
	public function check_if_reply_allowed() {

		// super admins can send message to anyone.
		if ( is_super_admin() || ! bpmts_is_loggedin_user_hidden() ) {
			return;
		}

		$message = __( 'Reply could not be sent.', 'buddypress-moderation-tools' );

		if ( ! function_exists('bp_nouveau' ) ) {
			echo "-1<div id='message' class='error'><p>{$message}</p></div>";
			exit( 0 );
		} else {
			wp_send_json_error( array(
				'feedback' => $message,
				'type' => 'error',
			) );
		}
	}
}
