<?php
/**
 * BuddyPress Moderation Tools:- User Message Builder.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\User\Messages;

use PressThemes\ModerationTools\Messages\Message_Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * User message builder.
 */
class User_Message_Builder extends Message_Builder {

	/**
	 * Token map.
	 *
	 * @param \WP_User $item item.
	 *
	 * @return array
	 */
	public function item_tokens_map( $item ) {
		return array(
			'{item.type}' => __( 'user', 'buddypress-moderation-tools' ),
			'{item.label}' => $item->display_name,
			'{item.url}'   => bp_core_get_user_domain( $item->ID ),
		);
	}
}

