<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * GeoDirectory Custom Post Types Import Export class
 *
 * @class       GeoDir_CP_Import_Export
 * @version     2.0.0
 * @package     GeoDir_Custom_Posts/Classes
 * @category    Class
 * @author      AyeCode Ltd
 */
class GeoDir_CP_Import_Export {

	public static function init() {
		if ( is_admin() ) {

			// add the column names
			add_filter( 'geodir_export_posts_csv_columns', array( __CLASS__, 'export_posts_csv_columns' ), 10, 2 );

			// add the post row info
			add_filter( 'geodir_export_posts_csv_row', array( __CLASS__, 'export_posts_csv_row' ), 10, 3 );

		}
	}

	/**
	 * Add the linked post ids to the export row.
	 *
	 * @param $post_info
	 * @param $post_id
	 * @param $post_type
	 *
	 * @return mixed
	 */
	public static function export_posts_csv_row($post_info, $post_id, $post_type ){
		$linked_post_types = self::linked_post_types($post_type);

		if(!empty($linked_post_types)){
			foreach ($linked_post_types as $lpt){

				$l_post_type = $lpt->htmlvar_name;
				$items = self::get_linked_ids( $post_id, $l_post_type );

				if(empty($post_info[$l_post_type])){
					if(!empty($items)){
						$items_string = implode(', ', array_map(function ($entry) {
							return $entry['linked_id'];
						}, $items));
						$post_info[$l_post_type] = $items_string;
					}else{
						$post_info[$l_post_type] = '';
					}
				}
			}
		}

		return $post_info;
	}

	/**
	 * Get the linked ids of the post and post_type.
	 *
	 * @param $post_id
	 * @param $post_type
	 *
	 * @return mixed
	 */
	public static function get_linked_ids($post_id,$post_type){
		global $wpdb;
		$results = $wpdb->get_results( $wpdb->prepare("SELECT linked_id FROM " . GEODIR_CP_LINK_POSTS . " WHERE post_id=%d AND linked_post_type=%s",$post_id,$post_type),ARRAY_A );

		return $results;
	}


	/**
	 * Add the linked post types as columns.
	 *
	 * @param $columns
	 * @param $post_type
	 *
	 * @return array
	 */
	public static function export_posts_csv_columns($columns, $post_type){
		$linked_post_types = self::linked_post_types($post_type);

		if(!empty($linked_post_types)){
			foreach ($linked_post_types as $lpt){
				$columns[] = $lpt->htmlvar_name;
			}
		}

		return $columns;
	}

	/**
	 * Check if there are any linked post types for the custom post type.
	 * 
	 * @param $post_type
	 *
	 * @return array
	 */
	public static function linked_post_types($post_type){
		global $wpdb;

		// check for cache
		$cache = wp_cache_get( "gd_cp_export_linked_post_types_".$post_type );
		if($cache !== false){
			return $cache;
		}

		$post_types = $wpdb->get_results( $wpdb->prepare( "SELECT htmlvar_name FROM " . GEODIR_CUSTOM_FIELDS_TABLE . " WHERE post_type=%s AND field_type='link_posts' ",$post_type ) );

		if(!empty($post_types)){
			// set cache
			wp_cache_set( "gd_cp_export_linked_post_types_".$post_type, $post_types, '',5 );
			return $post_types;
		}else{
			return array();
		}

	}
	
}