<?php
/**
 * Uninstall GeoDirectory Review Rating Manager
 *
 * Uninstalling GeoDirectory Review Rating Manager deletes data, tables and options.
 *
 * @package GeoDirectory_Review_Rating_Manager
 * @since 1.3.4
 */

// Exit if accessed directly.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

global $wpdb, $plugin_prefix;

$geodir_settings = get_option( 'geodir_settings' );

if ( ( ! empty( $geodir_settings ) && ( ! empty( $geodir_settings['admin_uninstall'] ) || ! empty( $geodir_settings['uninstall_geodir_review_rating_manager'] ) ) ) || ( defined( 'GEODIR_UNINSTALL_GEODIR_REVIEW_RATING_MANAGER' ) && true === GEODIR_UNINSTALL_GEODIR_REVIEW_RATING_MANAGER ) ) {
    $wpdb->hide_errors();
    
    if (!defined('GEODIRREVIEWRATING_VERSION')) {
        // Load plugin file.
        include_once('geodir_review_rating_manager.php');
    }
    
    if (empty($plugin_prefix)) {
        $plugin_prefix = $wpdb->prefix . 'geodir_';
    }

    //Remove settings
    $options = array(
        'rr_enable_rating',
        'rr_enable_images',
        'rr_enable_rate_comment',
        'rr_enable_sorting',
        'uninstall_geodir_review_rating_manager',
    );

    $geodir_options = geodir_get_settings();

    foreach ($options as $option){
        unset($geodir_options[$option]);
    }

    update_option( 'geodir_settings', $geodir_options);
    
    // Update data.
    $post_types = geodir_get_posttypes();
    foreach ($post_types as $post_type) {
        $detail_table = $plugin_prefix . $post_type . '_detail';
        
        if ($wpdb->get_var("SHOW COLUMNS FROM " . $detail_table . " WHERE field = 'ratings'")) {
            $wpdb->query("ALTER TABLE " . $detail_table . " DROP ratings");
        }
    }
    
    if ($wpdb->get_var("SHOW COLUMNS FROM " . GEODIR_REVIEWRATING_POSTREVIEW_TABLE . " WHERE field = 'read_unread'")) {
        $wpdb->query("ALTER TABLE " . GEODIR_REVIEWRATING_POSTREVIEW_TABLE . " DROP read_unread");
    }
    
    // Drop tables.
    $wpdb->query("DROP TABLE " . GEODIR_REVIEWRATING_STYLE_TABLE);
    $wpdb->query("DROP TABLE " . GEODIR_REVIEWRATING_CATEGORY_TABLE);
    $wpdb->query("DROP TABLE " . GEODIR_COMMENTS_REVIEWS_TABLE);
}