<?php
	
	if ( ! class_exists( 'ben_plug_restrict_usernames_emails_characters_nl' ) ) :
	
	class ben_plug_restrict_usernames_emails_characters_nl extends ben_plug_restrict_usernames_emails_characters_options {
		
		public function __construct() {
			parent::__construct();
		}
		
        function get_varchar_max_character() {
	    global $wpdb;
	
	        $dbName = $wpdb->dbname; // get database name of wordpress
	        $table_name = "{$wpdb->prefix}users";
	        $table = $wpdb->get_results( $wpdb->prepare(
		    "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = 'user_nicename' ",
		    $dbName, $table_name
	        ) );
	
	        if (!$table) return;
	        return $table[0]->CHARACTER_MAXIMUM_LENGTH;
	    }
		
		function mc_varchar() {
		global $wpdb; 
		$command = apply_filters( 'command_varchar_filter_BENrueeg_RUE', 'MODIFY COLUMN' );
		$wpdb->query( "ALTER TABLE $wpdb->users $command user_nicename varchar(255) NOT NULL DEFAULT '' " );
        }
		
        function change_varchar() {
	        if ($this->get_varchar_max_character() < 255)
	        $this->mc_varchar();
        }
		
        function varchar_register_form() {
			$this->change_varchar();
		}
		
        function core_n() {
	        return 'benrueeg_rue_wordpress_core_nace';
	    }
		
        function core_m() {
	        return 'benrueeg_core__maintenance';
	    }
        
		function update_core($feedback) {
			$this->store_users(true);
            $this->update_option('benrueeg_nicename_ucore_stored', 1);
            return $feedback;
        }
	
		function db__upgrade() {
	    global $wp_db_version;

        if (!is_admin()) return;
		if ($this->get_option('benrueeg_nicename_ucore_stored')) return;

        if ( (int) get_option( 'db_version' ) !== $wp_db_version ) {
			
		$this->store_users(true);

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        wp_upgrade();

		$this->change_varchar();
		$this->up_db_user_nicename();

		if ($this->get_option($this->core_n()))
		$this->delete_option($this->core_n());
	
		if ($this->get_option($this->core_m()))
		$this->delete_option($this->core_m());
			
        }
		
        }
		
		function mu_db__upgrade() {
	    global $wp_db_version;
		
        if (!is_admin() || !current_user_can('update_core')) return;
		
		if ( (int) get_option( 'db_version' ) === $wp_db_version || 
		$this->get_option('benrueeg_nicename_ucore_stored') ) return;
		
		$action = isset( $_GET['action'] ) ? $_GET['action'] : 'show';
		
	    if ( 'upgrade' ===  $action && 'upgrade.php' === $GLOBALS['pagenow'] && 
		(int) get_site_option( 'wpmu_upgrade_site' ) !== $GLOBALS['wp_db_version'] ) 
		{
		$this->store_users(true);
        $this->update_option('benrueeg_nicename__stored', time());
	    }
		
        }

		function mu_db__upgrade2() {
	    global $wp_db_version;

        if (!is_admin() || !current_user_can('update_core')) return;

		$action = isset( $_GET['action'] ) ? $_GET['action'] : 'show';
		$n = ( isset( $_GET['n'] ) ) ? true : false;
		
		if (isset( $_GET['action'] ) && isset( $_GET['n'] )) {
		$_action = 'upgrade' ===  $action && $n;
		} else if (isset( $_GET['action'] )) {
		$_action = 'upgrade' ===  $action;
		}

	    if ($this->get_option('benrueeg_nicename__stored') && $_action && 'upgrade.php' === $GLOBALS['pagenow']) {
			
        //require_once ABSPATH . 'wp-admin/includes/upgrade.php';		
        //wp_upgrade();
			
		$this->change_varchar();
		$this->up_db_user_nicename();

		if ($this->get_option($this->core_n()))
		$this->delete_option($this->core_n());

		if ($this->get_option($this->core_m()))
		$this->delete_option($this->core_m());
	
	    //update_option( 'db_version', $wp_db_version );
	    //update_option( 'db_upgraded', true );
	    $this->delete_option('benrueeg_nicename__stored');
		}
		
        }
		
		function upgrader_core_process_complete( $upgrader_object, $options ) {
        if ($options['action'] == 'update' && $options['type'] == 'core') {
			
        //require_once ABSPATH . 'wp-admin/includes/upgrade.php';		
        //wp_upgrade();
			
		$this->change_varchar();
		$this->up_db_user_nicename();

		if ($this->get_option($this->core_n()))
		$this->delete_option($this->core_n());
        if ($this->get_option('benrueeg_nicename_ucore_stored'))
        $this->delete_option('benrueeg_nicename_ucore_stored');
		if ($this->get_option($this->core_m()))
		$this->delete_option($this->core_m());	
		}
        }
		
		function store_users($true = '') {
		
		if ($true/* && !$this->get_option($this->core_m())*/)
		$this->update_option($this->core_m(), time());
	
		if (!$this->get_option($this->core_n())) {
        $this->update_option($this->core_n(), $this->nice_nick_name_users());
		}
        }
		
		protected function up_db_user_nicename() {
		global $wpdb;
		
		$blogusers = $this->get_option($this->core_n());
		
		if ($blogusers && is_array($blogusers)) {
		foreach ( $blogusers as $user_id => $user_nicename ) {
		$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->users SET `user_nicename` = %s WHERE `ID` = %d", sanitize_title( $user_nicename ), $user_id ) );
		}
		} else {
		$this->nice_nick_name_users('up1');
		}
        } 
		
        protected function up_user_nicename( $user_id, $field = '' ) {
			global $wpdb;
			
			$this->change_varchar();
			
			$nice = isset($_POST['nickname']) ? $_POST['nickname'] : '';
			$user = get_userdata( $user_id );
			if (!$user) return;
			if ($field == 'nickname' && $nice && $this->options('nicename_nickname') == 'nickname') {
			$user_nicename = $nice;	
			} else {
			$user_nicename = $user->user_login;
			}
		
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->users SET `user_nicename` = %s WHERE `ID` = %d", sanitize_title( $user_nicename ), $user_id ) ); // with [ $wpdb->query( $wpdb->prepare( "UPDATE ] no problem.
			//$wpdb->update( $wpdb->users, array( 'user_nicename' => sanitize_title( $user_nicename ) ), array( 'ID' => $user_id ), array( '%s' ), array( '%d' ) ); // but with [ $wpdb->update ] there is a problem if the varchar is changed just before user inserted and user_nicename is encoded sanitize_title.
        
		}
		
        function varchar() {
		  if ( $this->options('varchar') == 'enabled' ) {
		  $this->change_varchar();
		  } 
        }
		
		function maintenance_mode() {
			
            if (!$this->get_option($this->core_m())) return;
				
			if ( (time() - (int) $this->get_option($this->core_m())) > 360 )
			$this->delete_option($this->core_m());
			
            if (in_array($GLOBALS['pagenow'], array('upgrade.php','update-core.php')) || 
			function_exists( 'benrueeg_rue_mup_maintenance_mode' )) return;
			
			nocache_headers();
	        header( 'Retry-After: 600' );
	        wp_die(
		        __( 'Briefly unavailable for scheduled maintenance. Check back in a minute.' ),
		        __( 'Maintenance' ),
		        503
	        );
        }
		
		function admin___notice() {
		$cap = $this->mu() ? 'manage_network_options' : 'manage_options';
		if ( !current_user_can(apply_filters( 'manage_setts_cap_BENrueeg_RUE', $cap )) ) return;
		if ( (function_exists('benrueeg_rue_mup____db_upgrade_311') && function_exists('benrueeg_rue_mup_maintenance_mode')) || 
		$this->options('varchar') != 'enabled' ) return;
		
		$class = 'notice notice-error is-dismissible';
		$sty = 'background:#f1f1f1;direction:ltr;margin:0;padding:8px;word-wrap:break-word;overflow:scroll;';
		$message = __( 'There is a necessary file for this plugin that does not exist and it&apos;s: restrict-username-email-character.php add it manually on this path: wp-content\mu-plugins If it does not exist, add it to be like this: wp-content\mu-plugins\restrict-username -email-character.php Then add in the file exactly the following content:', 'restrict-usernames-emails-characters' );
		$msg = __( 'Click here to show the content to be copied', 'restrict-usernames-emails-characters');
		$here = '<input type="button" id="benrueeg_44_content_copied" class="button-secondary" value="'. $msg .'">';
		$content = "<pre style='$sty'>" . print_r(esc_html($this->getContentMuPlugin()) , TRUE) . '</pre>';
		
		printf( '<div class="%1$s"><p style="font-size:15px;">%2$s</p><p>%3$s</p><div style="display:none;" id="benrueeg_44_getContentMuPlugin">%4$s</div></div>', esc_attr( $class ), esc_html( $message ), $here, $content ); 
		}
		
	    function MuPlugin() {
	
	    // creating folder and php file in wp-content/mu-plugins
		$stu_dir   = WP_CONTENT_DIR . '/mu-plugins'; // nom du dossier
	    $php_file = $stu_dir . '/restrict-username-email-character.php'; // nom du fichier .php

		// On créé le dossier mu-plugins s'il n'éxiste pas
		if( !is_dir( $stu_dir ) ) mkdir( $stu_dir, 0755, true );

		// On créé le fichier php_file s'il n'éxiste pas
		//if( !file_exists( $php_file ) ) {
			file_put_contents( $php_file, $this->getContentMuPlugin() );
		//} 
		// On créé le fichier php_file s'il n'éxiste pas
		
	    // creating folder and php file in wp-content/mu-plugins
	    }

        function muplugins_is_empty($path) {
            $empty = true;
            $dir = opendir($path); 
            while($file = readdir($dir)) {
                if($file != '.' && $file != '..') {
                $empty = false;
                break;
                }
            }
            closedir($dir);
            return $empty;
        }
		
	    function RemoveMuPlugin() {
			$dir  = WP_CONTENT_DIR . '/mu-plugins'; // nom du dossier
	        $file = $dir . '/restrict-username-email-character.php'; // nom du fichier .php

			unlink($file);
			
			$_dir = WP_CONTENT_DIR . '/mu-plugins';
			if ($this->muplugins_is_empty($_dir) && is_dir($_dir))
				rmdir($_dir);
		}
		
		function _do_mu_upgrade() {
		return false;	
		}
		
	    function getContentMuPlugin() {
$content = <<<'HTML'
<?php
/** 
Plugin Name: restrict username email character
Description: restrict-username-email-character complement plugin
Version: 1.1
Author: BENACEUR
Author URI: https://benaceur-php.com/
License: GPL2
*/

add_action( 'init', 'benrueeg_rue_mup____db_upgrade_311' );
function benrueeg_rue_mup____db_upgrade_311() {
	$opts = get_option( 'BENrueeg_RUE_settings' );
	$varchar = isset($opts['varchar']) ? $opts['varchar'] : '' ;
	if (is_multisite() || $varchar != 'enabled') return;

    if ('upgrade.php' === $GLOBALS["pagenow"] && !get_option('benrueeg_nicename_ucore_stored') ) {
    nocache_headers();
    wp_redirect( admin_url('/index.php') ); exit;
    }
}

add_action( 'init', 'benrueeg_rue_mup_maintenance_mode' );
function benrueeg_rue_mup_maintenance_mode() {
	$opts = get_option( 'BENrueeg_RUE_settings' );
	$varchar = isset($opts['varchar']) ? $opts['varchar'] : '' ;
	$option = is_multisite() ? get_site_option('benrueeg_core__maintenance') : get_option('benrueeg_core__maintenance');
    if (!$option || $varchar != 'enabled') return;
	
	if ( (time() - (int) $option) > 360 ) {
		if (is_multisite()) {
		delete_site_option('benrueeg_core__maintenance');
		} else {
		delete_option('benrueeg_core__maintenance');	
		}
	}
	
    if (in_array($GLOBALS['pagenow'], array('upgrade.php','update-core.php'))) return;
			
		nocache_headers();
	    header( 'Retry-After: 600' );
	    wp_die(
		    __( 'Briefly unavailable for scheduled maintenance. Check back in a minute.' ),
		    __( 'Maintenance' ),
		      503
	    );
}
HTML;
		
	    return $content;
	    }
		
	}
	new ben_plug_restrict_usernames_emails_characters_nl();
		
	endif;				