<?php
/**
 * Plugin UI Base Structure
 *
 * WEB3 Login Config guides.
 *
 * @category   Core
 * @package    MoWeb3
 * @author     miniOrange <info@xecurify.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link       https://miniorange.com
 */
namespace MoWeb3\Base;
use MoWeb3\MoWeb3Support;
use MoWeb3\Base\MoWeb3Loader;





/**
 * Class to render Basic Structure of plugin UI.
 *
 * @category Core
 * @package  MoWeb3
 * @author   miniOrange <info@xecurify.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link     https://miniorange.com
 */





class MoWeb3BaseStructure {

	
	private $loader;

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		
		$this->loader = new MoWeb3Loader();
	}


	/**
	 * Function to add Plugin to menu list.
	 */

	public function admin_menu() {
        
        $page = add_menu_page( 'WEB 3.0 ' . __( 'Configure WEB3', 'mo_web3_settings' ), 'miniOrange WEB3 Login', 'administrator', 'mo_web3_settings', array( $this, 'menu_options' ), MOWEB3_URL . 'resources/images/miniorange.png' );
		global $submenu;
		if ( is_array( $submenu ) && isset( $submenu['mo_web3_settings'] ) ) {
			$submenu['mo_web3_settings'][0][0] = __( 'Configure WEB3', 'mo_web3_settings' ); // phpcs:ignore
		}
	}

	/**
	 * Render Skeleton.
	 */
	public function menu_options() {
		global $mo_web3_util;

		$currenttab = isset( $_GET['tab']) ? sanitize_text_field( wp_unslash( ( $_GET['tab'])) ): ''; // phpcs:ignore
		?>
		<div id="mo_api_authentication_settings">
			<div id='mrablock' class='mweb3-overlay dashboard'></div>
			<div class="miniorange_container">
				<?php
					if('licensing' !== $currenttab){
						$this->content_navbar( $currenttab );
						?><table style="width:100%;">
							<tr>
								<td style="vertical-align:top;width:65%;">
									<?php
										$this->loader->load_current_tab( $currenttab );
									?>
								</td>
								
								<td style="vertical-align:top;padding-left:1%;">
								<?php
									if('licensing' !== $currenttab){
										$support = new MoWeb3Support();
										$support->support();
									}
								?></td>
							</tr>
						</table><?php 
					}else{
						$this->loader->load_current_tab( $currenttab );						
					}
			?></div>

		</div>
		<?php
	}

	/**
	 * Function to render tabs.
	 *
	 * @param string $currenttab Current active tab.
	 */
	public function content_navbar( $currenttab ) {
		global $mo_web3_util;
		?>
		<div class="wrap">
			<div class="header-warp">
				<h1>miniOrange Web 3.0 Login</h1>

				<div><img style="float:left;" src="<?php echo esc_attr(MOWEB3_URL) . '/resources/images/logo.png'; ?>"></div>
		</div>
		<div id="tab">
		<h2 class="nav-tab-wrapper">
			<a id="tab-config" class="nav-tab <?php echo ( 'config' === esc_attr($currenttab) || '' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=config">Configure Settings</a>
			<a  class="nav-tab <?php echo ( 'content_restriction' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=content_restriction">NFT Content Restriction</a>
			<a  class="nav-tab <?php echo ( 'role_mapping' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=role_mapping">Role Mapping</a>
			<a  class="nav-tab <?php echo ( 'shortcode_info' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=shortcode_info">Shortcode Info</a>
			<a  class="nav-tab <?php echo ( 'add_ons' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=add_ons">	Add Ons</a>
			<?php if($mo_web3_util->mo_web3_get_option( 'mo_web3_admin_email' )){ ?>
			<a  class="nav-tab <?php echo ( 'account' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=account">Account Setup</a>
		<?php } ?>

			<a  class="nav-tab <?php echo ( 'licensing' === esc_attr($currenttab) ) ? 'mo-web3-nav-tab-active' : ''; ?>" href="admin.php?page=mo_web3_settings&tab=licensing">Licensing</a>

		</h2>
		</div>
		<?php
	}
    


    



	public function  get_ui(){

    ?>
        <!doctype html>
            <html lang="en">
            <head>
                <!-- Required meta tags -->
                <meta charset="utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

              

            </head>
                <body style="background-color:floralwhite;">


                    <div class="container mt-5" style="background-color:floralwhite;">
                        <h1>User Form</h1>
                        <form  action="" method="post">
                            <input type="hidden" name="option" value="register_customer" />
                            <?php wp_nonce_field( 'register_customer', 'register_customer_nonce' ); ?>
                            <div class="row form-group" >
                                <div class="col-12 col-sm-3">
                                    <label >First Name :</label>
                                </div>

                                <div class="col-12 col-sm-9">
                                    <input type="text" class="form-control" name="fname" required>
                                </div>
                                
                            </div>

                            <div class=" row form-group ">
                                <div class="col-12 col-sm-3">
                                    <label>Last Name :</label>
                                </div>
                                <div class="col-12 col-sm-9">
                                    <input type="text"  class="form-control" name="lname" required></textarea>
                                </div>
                            </div>
                            <div class="form-group offset-3 mr-1">
                                &nbsp;<button type="submit" class="btn-lg btn-primary">&nbsp;&nbsp;Submit&nbsp;&nbsp;</button>
                            </div>
                          

                        </form>


                    </div>

                    

                    <footer>
                        <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-auto">
                                    <p>©Copyright 2022 Web3.0</p>
                                </div>
                            </div>
                        </div>
                    </footer>
            
				</body>
            </html>
<?php
    }
}
?>