<?php
/**
 * Core
 *
 * web3 Method view Handler.
 *
 * @category   Common, Core
 * @package    MoWeb3\MoWeb3MethodViewHandler
 * @author     miniOrange <info@xecurify.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link       https://miniorange.com
 */

namespace MoWeb3;

use MoWeb3\Base\MoWeb3InstanceHelper;
use MoWeb3\view\ButtonView\MoWeb3View;
use MoWeb3\view\SettingsView\MoWeb3SettingsView;

/**
 * Class to Method View Handler.
 *
 * @category Common, Core
 * @package  MoWeb3\MoWeb3MethodViewHandler
 * @author   miniOrange <info@xecurify.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link     https://miniorange.com
 */

class MoWeb3MethodViewHandler {

    /**
	 * Instance Helper
	 *
	 * @var \MoWeb3\Base\MoWeb3InstanceHelper $instance_helper
	 * */
    private $instance_helper;
    
    private $moweb3_setting_view;
    private $moweb3_view;

    /**
     * Constructor
     */

    public $util;

    public function __construct() {

        $this->util   =new \MoWeb3\MoWeb3Utils;
        $this->instance_helper     = new MoWeb3InstanceHelper();
        $this->moweb3_view         = new MoWeb3View();
        $this->moweb3_setting_view = new MoWeb3SettingsView();
        wp_enqueue_style( 'mo_web3_style', MOWEB3_URL . '/classes/common/Web3/resources/css/bootstrap/bootstrap.min.css', array(), $ver = "1.0.1", $in_footer = false );
        $this->moweb3_view->mo_web3_wp_enqueue();


    }



    /**
     * Render UI of Config Tab
     */
    public function render_ui()
    {
        
        ?>
		    <div class="mo_support_layout container">
                <div class="mo_web3_settings_table mt-3">


                    <div style="min-height:75px">
                        <h2>Plugin Configuration : </h2>
                    </div>
                    
                    <div class="row mb-4">

                        <div class="col-12 col-sm-4">
                            <h6>Enable Web3 user Login :</h6>
                        </div>

                        <div class="col-12 col-sm-8">
                            <?php $this->moweb3_setting_view->toggle_display_of_multiple_login_button(); ?>
                        </div>

                    </div>

                    <div class="row mb-4">

                        <div class="col-12 col-sm-4">
                            <h6>Custom Login Button Text:</h6>
                        </div>

                        <div class="col-12 col-sm-8">
                            <?php $this->moweb3_setting_view->custom_text_login_button(); ?>
                        </div>

                    </div>

                    <div class="row mb-4">

                        <div class="col-12 col-sm-4">
                            <h6>Test All Enabled Cryto Wallet:</h6>
                        </div>

                        <div class="col-12 col-sm-8">
                            <?php $this->moweb3_setting_view->test_configuration(); ?>
                        </div>

                    </div>


                    <div style="display:none">
                        <hr>

                        <div style="min-height:75px">
                            <h2>NFT Setting : </h2>
                        </div> 

                        <div style="min-height:150px">
                            <?php $this->moweb3_setting_view->nft_setting(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <br>

        <?php
    }

}
?>