<?php


namespace MoWeb3\controller;
require_once (realpath(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Keccak'.DIRECTORY_SEPARATOR.'Keccak.php'));
require_once (realpath(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Elliptic'.DIRECTORY_SEPARATOR.'EC.php'));
require_once (realpath(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Elliptic'.DIRECTORY_SEPARATOR.'Curves.php'));
require_once (realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'Base32' . DIRECTORY_SEPARATOR . 'class-base32.php'));

use Elliptic\EC;
use kornrunner\Keccak;
use Base32\Base32;
use MoWeb3\MoWeb3Utils;


class MoWeb3FlowHandler{


  private $data;
  private $request;
  private $utils;
  private $is_testing_wallet_address;

  public function __construct() {

    $this->utils = new \MoWeb3\MoWeb3Utils();
    $this->is_testing_wallet_address =false;//"0x3D9B0A7ef1CcEAda457001A6d51F28FF61E39904";

    add_action('wp_ajax_nopriv_type_of_request', array($this,'type_of_request'));
    add_action('wp_ajax_type_of_request', array($this,'type_of_request'));

    add_action('init',array($this,'hidden_form_data'));
    add_action( 'admin_init', array( $this, 'toggle_crypto_wallet_button_display' ) );
    add_action( 'admin_init', array( $this, 'change_display_button_text' ) );
    add_action( 'admin_init', array( $this, 'nft_save_setting' ) );
    
	}

  public function toggle_crypto_wallet_button_display(){

    if(isset($_POST['mo_web3_multiple_button_display_nonce']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mo_web3_multiple_button_display_nonce'] ) ), 'mo_web3_multiple_button_display' )){

      $mo_web3_display_multiple_button = array();

      global $mo_web3_util;

      $multiple_crypto_wallet = $mo_web3_util->get_multiple_crypto_wallet();

      foreach($multiple_crypto_wallet as $key => $value){
        $name = $value["id"];
        $check=isset($_POST[$name])?sanitize_text_field( wp_unslash( $_POST[$name] ) ):'';
        $mo_web3_display_multiple_button[$name] = $check;
      }

      $this->utils->mo_web3_update_option( 'mo_web3_display_multiple_button',$mo_web3_display_multiple_button);

    }
  }


  public function nft_save_setting(){

    if(isset($_POST['mo_web3_content_restriction_nonce']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mo_web3_content_restriction_nonce'] ) ), 'mo_web3_content_restriction' )){


      $pageUrl        =isset($_POST['pageUrl'])?sanitize_text_field( wp_unslash( $_POST['pageUrl'] ) ):'';
      $contractAddress=isset($_POST['contractAddress'])?sanitize_text_field( wp_unslash( $_POST['contractAddress'] ) ):'';
      $blockchain     =isset($_POST['blockchain'])?sanitize_text_field( wp_unslash( $_POST['blockchain'] ) ):'';

   
      $pageID = url_to_postid($pageUrl);
      
      if($pageID===0){
        global $mo_web3_util;
        $mo_web3_util->mo_web3_update_option( \MoWeb3Constants::PANEL_MESSAGE_OPTION, "Page URL: ".$pageUrl." does not exists!!" );
        $mo_web3_util->mo_web3_show_error_message();
      }else{
  
        $this->utils->mo_web3_update_option( 'mo_web3_nft_settings',array(
          
          'pageID' =>  $pageID,
          'contractAddress' => $contractAddress,
          'blockchain' => $blockchain

        ));

        global $mo_web3_util;
        $mo_web3_util->mo_web3_update_option( \MoWeb3Constants::PANEL_MESSAGE_OPTION, 'NFT setting saved' );
        $mo_web3_util->mo_web3_show_success_message();
        
      }
    }
  }




  public function change_display_button_text(){

    if(isset($_POST['mo_web3_button_custom_text_nonce']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mo_web3_button_custom_text_nonce'] ) ), 'mo_web3_button_custom_text' )){
        
      $button_text  =  isset($_POST['mo_web3_button_custom_text'])?sanitize_text_field( wp_unslash( $_POST['mo_web3_button_custom_text'] ) ):'Login with CryptoWallet';

      $this->utils->mo_web3_update_option( 'mo_web3_button_custom_text',$button_text);
      global $mo_web3_util;
      $mo_web3_util->mo_web3_update_option( \MoWeb3Constants::PANEL_MESSAGE_OPTION, 'Login Button Text Changed!' );
      $mo_web3_util->mo_web3_show_success_message();

    }

  }
  


  public function hidden_form_data(){

    if(isset($_POST['mo_web3_hiddenform_nonce']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mo_web3_hiddenform_nonce'] ) ), 'mo_web3_wp_nonce' )){
      
      $address=isset($_POST['address'])?sanitize_text_field( wp_unslash( $_POST['address'] ) ):'';
      $nonce  =isset($_POST['nonce'])?sanitize_text_field( wp_unslash( $_POST['nonce'] ) ):'';
      $hasNft =isset($_POST['checkNft'])?sanitize_text_field( wp_unslash( $_POST['checkNft'] ) ):'';

      $storedNonce=$this->utils->mo_web3_get_transient( $address);

      if( $nonce==$storedNonce){

        $this->utils->mo_web3_user_check($address);
        $wallet_address=$address;

        $user = get_user_by("login",$address);
        
        clean_user_cache( $user->ID);
        wp_clear_auth_cookie();
        wp_set_current_user( $user->ID );
        wp_set_auth_cookie( $user->ID, true );
        update_user_caches( $user);

        if($this->is_testing_wallet_address){// for testing purpose
          $address = $this->is_testing_wallet_address;
        }

        do_action( 'wp_login', $user->data->user_login, $user );
        
        $key = $user->ID."_owned_nft";
        update_user_meta($user->ID,$key,$hasNft);
        update_user_meta($user->ID,"wallet_address",$wallet_address);

        $nonce = uniqid();
        $expiration = 24*60*60;
        
        $this->utils->mo_web3_set_transient( $address, $nonce, $expiration );

        if(wp_safe_redirect(site_url())){
          die;
        }else{
          wp_send_json("NOT ABLE TO REDIRECT");
        }
        exit();
      }
    }
    else if(isset($_POST['mo_web3_hiddenform_submission_nonce']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mo_web3_hiddenform_submission_nonce'] ) ), 'mo_web3_wp_nonce' )){
         
      // special case handle for perawallet, phantom, as signature concept is not present in these wallet login
      // update: this no longer handles MyAlgo wallet
      $address=isset($_POST['address'])?sanitize_text_field( wp_unslash( $_POST['address'] ) ):'';
        $this->utils->mo_web3_user_check($address);
        $user=get_user_by("login",$address);
        clean_user_cache( $user->ID);
        wp_clear_auth_cookie();
        wp_set_current_user( $user->ID );
        wp_set_auth_cookie( $user->ID, true );
        update_user_caches( $user);

        if(wp_safe_redirect(site_url())){
          die;
        }else{
          wp_send_json("NOT ABLE TO REDIRECT");
        }
        die;
    }
  }

  
  public function get_ethereum_or_polygon_api_data($contract_address,$wallet_address,$chain){

    $url = null;
    $response =null;
    $args = array(
      'headers' => array(
        "Content-Type" => "application/json",
        "Authorization" =>\MoWeb3Constants::NFT_PORT_AUTHORIZATION_Key
    ));
    $url = \MoWeb3Constants::NFT_PORT_API."accounts/".$wallet_address."?chain=".$chain."&contract_address=".$contract_address;
    $response = wp_remote_get( $url,$args );
    return $response;
  }

  public function get_solana_api_data($wallet_address,$solana_field_key,$solana_field_value){

    $url = null;
    $response =null;
    $args = array(
      'headers' => array(
        "Content-Type" => "application/json",
        "Authorization" => \MoWeb3Constants::NFT_PORT_AUTHORIZATION_Key
    ));

    if("solanaMintAddress"==$solana_field_key){
      $url = \MoWeb3Constants::NFT_PORT_API."solana/nft/{$solana_field_value}";
    }else if("solanaCollectionID"==$solana_field_key || "solanaCollectionKey"==$solana_field_key){
      $url = \MoWeb3Constants::NFT_PORT_API."solana/nfts/{$solana_field_value}";
    }
    $response = wp_remote_get($url,$args);
    
    return $response;
  }

  public function get_token_data_through_api($contract_address,$wallet_address,$chain,$solana_field_key=null,$solana_field_value=null){

    $url = null;
    $chain = strtolower($chain);
    $response = null;
    switch ($chain) {
      case "ethereum":
      case "polygon":
        $response = $this->get_ethereum_or_polygon_api_data($contract_address,$wallet_address,$chain);
        break;
      case "solana":
        $response = $this->get_solana_api_data($wallet_address,$solana_field_key,$solana_field_value);
        break;
      default:
        $response =array("error"=>"invalid case!!");
        wp_send_json_error($response,500);
    }
    

    if ( is_wp_error( $response ) ) {
      $error_message = $response->get_error_message();
      $error_message = "Something went wrong: ".esc_attr($error_message);
      $response =array("error"=>$error_message);
      wp_send_json_error($response,500);
    }
    $response = wp_remote_retrieve_body($response);
    wp_send_json($response);
  }



  public function type_of_request(){


    if(wp_verify_nonce( sanitize_text_field( wp_unslash( $_REQUEST['mo_web3_verify_nonce'] ) ), 'mo_web3_wp_nonce' ) && isset($_REQUEST['request'])){
      
      $request=sanitize_text_field( wp_unslash( $_REQUEST['request'] ) );
      if ($request== "login"){
        $this->handle_login_request();
      }
      elseif($request == "auth"){
        $this->handle_auth_request();
      }
      elseif("getSolanaTokenDetails" == $request){

        $wallet_address     = isset($_POST['walletAddress'])?sanitize_text_field( wp_unslash( $_REQUEST['walletAddress'])):null;
        $field_value        = isset($_POST['fieldValue'])?sanitize_text_field( wp_unslash( $_REQUEST['fieldValue'])):null;
        $field_key          = isset($_POST['fieldKey'])?sanitize_text_field( wp_unslash( $_REQUEST['fieldKey'])):null;
        $chain              = "solana";

        $this->get_token_data_through_api(null,$wallet_address,$chain,$field_key,$field_value);
      }
      elseif("getUserHoldNFTData" == $request ){
        $contract_address = isset($_POST['contractAddresses'])?sanitize_text_field( wp_unslash( $_REQUEST['contractAddresses'])):null;
        $chain            = isset($_POST['blockchain'])?sanitize_text_field( wp_unslash( $_REQUEST['blockchain'])):null;
        $wallet_address   = isset($_POST['walletAddress'])?sanitize_text_field( wp_unslash( $_REQUEST['walletAddress'])):null;
        $this->get_token_data_through_api($contract_address,$wallet_address,$chain,null);
      }
      elseif($request == "auth_algorand"){
        $this->handle_auth_request_algorand();
      }
      elseif($request == "auth_phantom"){
        $this->handle_auth_request_phantom();
      }
      
    }

  }

  public function handle_auth_request_phantom(){
    $address=isset($_REQUEST['address'])?sanitize_text_field( wp_unslash( $_REQUEST['address'] ) ):'';
      $signature=isset($_REQUEST['signature'])?sanitize_text_field( wp_unslash( $_REQUEST['signature'] ) ):'';
      $nonce = $this->utils->mo_web3_get_transient( $address);
      $message="Sign this message to validate that you are the owner of the account. Random string: " . $nonce;
      $signature=base58_decode($signature);
      $pubkey=base58_decode($address);
      $verifyResult = sodium_crypto_sign_verify_detached($signature, $message, $pubkey);
      if (1 == $verifyResult)
      {
        $nonce = uniqid();
        $expiration = 24 * 60 * 60;
        $this->utils->mo_web3_set_transient($address, $nonce, $expiration);

        $admin_nft_setting = $this->utils->mo_web3_get_option('mo_web3_nft_settings');

        $response = array(
          'isSignatureVerified'  => 1,
          'nonce'       => $nonce,

        );
        if ($admin_nft_setting) {
          $response["adminNftSetting"] = $admin_nft_setting;
        }
        wp_send_json($response);
      }
      else
      {
        $response = array(
          'isSignatureVerified'  => 0,
          'nonce'       => null
        );
        wp_send_json($response);
      }

  }

  public function handle_auth_request_algorand()
  {
    $address = isset($_REQUEST['address'])?sanitize_text_field( wp_unslash( $_REQUEST['address'] ) ):'';
    $signature = isset($_REQUEST['signature'])?sanitize_text_field( ( $_REQUEST['signature'] ) ):'';
    
    $signature = explode(',',$signature);
    $signature = pack("C*", ...$signature);

    $nonce = $this->utils->mo_web3_get_transient( $address);
    $data ="Sign this message to validate that you are the owner of the account. Random string: " . $nonce;
    $data = 'MX' . $data;

    try
    {
      $pk = $this->retrieve_public_key_algorand($address);    

      $result = sodium_crypto_sign_verify_detached($signature,$data,$pk);
      
      if (1 == $result)
      {
        $nonce = uniqid();
        $expiration = 24 * 60 * 60;
        $this->utils->mo_web3_set_transient($address, $nonce, $expiration);

        $admin_nft_setting = $this->utils->mo_web3_get_option('mo_web3_nft_settings');

        $response = array(
          'isSignatureVerified'  => 1,
          'nonce'       => $nonce,

        );
        if ($admin_nft_setting) {
          $response["adminNftSetting"] = $admin_nft_setting;
        }
        wp_send_json($response);
      }
      else
      {
        $response = array(
          'isSignatureVerified'  => 0,
          'nonce'       => null
        );
        wp_send_json($response);
      }
    }
    catch(\Exception $e)
    {
      exit();
    }

    return;
  }

  public function retrieve_public_key_algorand($address)
  {
    if (\MoWeb3Constants::ALGORAND_ADDRESS_LENGTH !== strlen($address))
    {
      exit();
    }
    $decoded = Base32::decode($address);
    $byte_array = unpack('C*', $decoded);
    $pk_Uint8_Array = array_slice($byte_array, 0, \MoWeb3Constants::ALGORAND_ADDRESS_BYTE_LENGTH - \MoWeb3Constants::ALGORAND_CHECKSUM_BYTE_LENGTH);
    $pk = pack("C*", ...$pk_Uint8_Array);
    return $pk;
  }


  public function handle_login_request(){

    $address = isset($_REQUEST['address'])?sanitize_text_field( wp_unslash( $_REQUEST['address'] ) ):'';
    $nonce=$this->utils->mo_web3_get_transient( $address );

    if ($nonce) {
      wp_send_json("Sign this message to validate that you are the owner of the account. Random string: " . $nonce);
    }
    else {
      $nonce =uniqid();
      $expiration=24*60*60;
      $this->utils->mo_web3_set_transient( $address, $nonce, $expiration );
      wp_send_json("Sign this message to validate that you are the owner of the account. Random string: " . $nonce);
    }

  }

  public function pub_key_to_address($pubkey) {
    return "0x" . substr(Keccak::hash(substr(hex2bin($pubkey->encode("hex")), 1), 256), 24);
  }

  public function verify_signature($message, $signature, $address) {
  
    $msglen = strlen($message);
    $hash   = Keccak::hash("\x19Ethereum Signed Message:\n{$msglen}{$message}", 256);
    $sign   = ["r" => substr($signature, 2, 64),
              "s" => substr($signature, 66, 64)];
    $recid  = ord(hex2bin(substr($signature, 130, 2))) - 27;
    if ($recid != ($recid & 1)){
      if(preg_match('/00$/', $signature))
        $recid = 0;
      else if(preg_match('/01$/', $signature))
        $recid = 1;
      else
        return 0;
    }

    $ec = new EC('secp256k1');
    $pubkey = $ec->recoverPubKey($hash, $sign, $recid);
  
    return $address == $this->pub_key_to_address($pubkey);
  }

  public function handle_auth_request(){

    $address = isset($_REQUEST['address'])?sanitize_text_field( wp_unslash( $_REQUEST['address'] ) ):'';
    $signature = isset($_REQUEST['signature'])?sanitize_text_field( wp_unslash( $_REQUEST['signature'] ) ):'';

  
    $nonce = $this->utils->mo_web3_get_transient( $address);
    $message ="Sign this message to validate that you are the owner of the account. Random string: " . $nonce;

    if($this->verify_signature($message, $signature, $address)){
      $nonce =uniqid();
      $expiration=24*60*60;
      $this->utils->mo_web3_set_transient($address, $nonce, $expiration);

      $admin_nft_setting=$this->utils->mo_web3_get_option( 'mo_web3_nft_settings');
      

      $response = array(
        'isSignatureVerified'  => 1,
        'nonce'       => $nonce,
        
      );
      if($admin_nft_setting){
        $response["adminNftSetting"] = $admin_nft_setting;

      }
      wp_send_json($response);

    }else{
      $response = array(
        'isSignatureVerified'  => 0,
        'nonce'       => null
      );
      wp_send_json($response);
    }
  }
}
?>