<?php
/**
 * Core
 *
 * Create MoWeb3 Method view Handler.
 *
 * @category   Common, Core
 * @package    MoWeb3\view\SettingsView
 * @author     miniOrange <info@xecurify.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link       https://miniorange.com
 */
namespace MoWeb3\view\AddOnsView;




class MoWeb3AddOns{
    
    /**
    * Constructor
    */
    public $util;
    public $addOns;
    public function __construct() {
        
		$this->util         =   new \MoWeb3\MoWeb3Utils;  
        $this->set_addOns();
        wp_enqueue_style( 'mo_web3_custom_style', MOWEB3_URL . '/classes/common/Web3/resources/css/styles.css', array(), $ver = \MoWeb3Constants::STYLES_CSS_VERSION, $in_footer = false ); 
        
    }

    public function set_addOns(){
        $this->addOns=array(
            "BuddyBoss" => array(
                "image"=>"buddyboss.png",
                "title"=>"BuddyBoss Integration",
                "description"=>"Integrate user cryptowallet information obtained from web3 authentication plugin to  NFT Token Gate Profiles on BuddyBoss.",
                "height"=>"150px",
                "guide"=>[
                            "BuddyBoss_Profile_Mapping" => [ 
                                                            "info_url"=>"",
                                                            "youtube_url"=>""
                                                           ]
                        ]
            ),
            "WooCommerce" => array(
                "image"=>"woocommerce.png",
                "title"=>"WooCommerce Integration",
                "description"=>"Based on the user information gathered by the web3 plugin, this provides WooCommerce Product and Coupon NFT Token Gating for Web3 users.",
                "height"=>"125px",
                "guide"=>[
                    "WooCommerce Product Gating" => [ 
                                                    "info_url"=>"https://plugins.miniorange.com/woocommerce-product-gating-based-on-nft-token",
                                                    "youtube_url"=>""
                                                   ],
                    "WooCommerce Coupon Gating" => [ 
                                                    "info_url"=>"https://plugins.miniorange.com/woocommerce-coupon-discount-based-on-nft",
                                                    "youtube_url"=>"https://www.youtube.com/watch?v=Fpc38jsJDPY"
                                                   ],

                ]

            ),
            "MemberPress" => array(
                "image"=>"memberpress.png",
                "title"=>"MemberPress Integration",
                "description"=>"Based on the user information gathered by the web3 authentication plugin, this provides Membership NFT Token Gating for Web3 users.",
                "height"=>"150px",
                "guide"=>[
                    "Memberpress Membership Mapping" => [ 
                                                        "info_url"=>"https://plugins.miniorange.com/membership-mapping-based-on-nfts",
                                                        "youtube_url"=>""
                                                        ],

                ]
            ),
            "BradMax" => array(
                "image"=>"bradmax.png",
                "title"=>"BradMax Player Integration",
                "description"=>"Get Video Analytics for Web3 Users for videos hosted on Bradmax player.",
                "height"=>"150px",
                "guide"=>[
                    "BradMax User Analytics" => [ 
                                                    "info_url"=>"",
                                                    "youtube_url"=>""
                                                ],

                ]
            ),
            "LearnDash" => array(
                "image"=>"LearnDash.png",
                "title"=>"LearnDash Integration",
                "description"=>"LearnDash is popular WordPress LMS plugin.This add-on will NFT Gate the users to LearnDash groups .",
                "height"=>"60px",
                "guide"=>[
                    "LearnDash Group Mapping" => [ 
                                                    "info_url"=>"",
                                                    "youtube_url"=>""
                                                 ],

                ]
            )
        );  
    }

    public function view_addOn_card(){

        foreach($this->addOns as $addOn){
        ?>
        <div class="card card-custom bg-white border-white border-0 custom-card-css">
            <div class="card-custom-avatar">
                <img height="<?php echo esc_attr($addOn['height']);?>" src="<?php echo esc_attr(MOWEB3_URL)."/classes/common/Web3/resources/images/{$addOn['image']}"; ?>" alt="Avatar" />
            </div>
            <div class="custom-card-text">
                <div class="card-body addon-card-body">
                    <h3 class="card-title"><?php echo esc_attr($addOn["title"]); ?></h3>
                    <p class="card-text" >
                        <?php echo esc_attr($addOn["description"]); ?>
                    </p>
                </div>
                <div class="card-footer addon-card-footer">
                    <?php 
                    foreach($addOn["guide"] as $guide_name=>$guide_links){
                        if($guide_links['info_url'] || $guide_links['youtube_url']){
                            echo $guide_name;
                            echo '<div style="display:flex;flex-direction:row;margin:4px;justify-content:space-between;">';
                            if( "" != $guide_links['info_url']){
                                ?>
                                <button class="addon-card-learn-more-button">
                                    <a href="<?php echo esc_attr($guide_links['info_url']);?>"  target="_blank" class="addon-link">
                                        <div><span style="color:black;" class="dashicons dashicons-media-document"></span></div>
                                        <h7 style="margin-left:0px;">Setup Guide</h7>
                                    </a>
                                </button>
                                <?php
                            }
                            if( "" != $guide_links['youtube_url']){
                                ?>
                                <button class="addon-card-learn-more-button" >
                                    <a href="<?php echo esc_attr($guide_links['youtube_url']);?>" target="_blank" class="addon-link">
                                        <div><span style="color:red;" class="dashicons dashicons-youtube"></span></div>
                                        <h7 style="margin-left:0px;">Youtube Guide</h7>
                                    </a>
                                </button>
                                <?php
                            }
                        echo '</div>';
                        }
                    }
                    ?>
                </div>
            </div>
        </div>

        <?php
        }
    }


    public function view(){
        ?><div class="mo_support_layout container prem-info" >
                <div style="display:grid;grid-template-columns: repeat(3, 1fr);">

                    <?php
                    $this->view_addOn_card();
                    ?>

                </div>             
        </div>
        <?php
    }
}
?>