<?php
/**
 * Get the 404 page icon.
 *
 * @since 2.0.0
 *
 * @param integer $version Theme version no.
 *
 * @return string
 */
function bb_theme_get_404_svg_code( $version = 1 ) {
	$svg_code = '';
	switch ( $version ) {
		case 1:
			$svg_code = '<svg width="312" height="249" viewBox="0 0 312 249" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
			<rect width="312" height="249" fill="url(#pattern0)"/>
			<defs>
			<pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
			<use xlink:href="#image0_6936_12439" transform="translate(-0.0174878) scale(0.00194179 0.00243309)"/>
			</pattern>
			<image id="image0_6936_12439" width="533" height="411" xlink:href="data:image/png;base64,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"/>
			</defs>
			</svg>';
			break;
		case 2:
			$svg_code = '<svg viewBox="0 0 300 138" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M55.9813 14.4114C55.8725 15.6181 56.2306 17.5388 58.5339 15.5678C60.8371 13.5967 61.2526 15.5433 61.1725 16.7631C61.2447 17.9262 61.8678 19.7911 63.7824 17.9454C66.1756 15.6383 66.7294 17.7732 66.7078 19.2706" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path d="M175.561 126.729C174.642 126.838 173.094 126.541 174.257 124.49C175.42 122.438 173.843 122.092 172.909 122.175C171.995 122.123 170.449 121.593 171.576 119.885C172.985 117.75 171.24 117.284 170.082 117.318" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path d="M37.7985 110.395C38.7176 110.504 40.2652 110.207 39.1024 108.156C37.9396 106.104 39.5165 105.758 40.4503 105.841C41.3644 105.789 42.9109 105.259 41.7835 103.551C40.3743 101.416 42.1193 100.95 43.2779 100.984" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<circle opacity="0.5" cx="188.069" cy="28.2934" r="4.37515" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path d="M263.872 51.1123C264.762 51.9969 266.477 52.9891 266.216 49.8813C265.956 46.7734 267.723 47.738 268.64 48.6088C269.597 49.3229 271.417 50.0709 271.037 47.3502C270.562 43.9493 272.556 44.9304 273.724 45.9393" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path opacity="0.5" d="M158.285 6.7766C159.175 7.6612 160.89 8.65345 160.629 5.5456C160.369 2.43775 162.136 3.40234 163.053 4.27311C164.01 4.98719 165.83 5.73517 165.45 3.01446C164.975 -0.386428 166.969 0.594681 168.137 1.60366" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<g filter="url(#filter0_b_6658_10486)">
			<mask id="path-7-inside-1_6658_10486" fill="white">
			<path d="M73.3458 46.8446V80.2906H48.0205L72.9329 46.8446H73.3458ZM73.3458 98.1443V118.108C73.3458 118.43 73.607 118.692 73.9292 118.692H91.3436C91.6658 118.692 91.927 118.43 91.927 118.108V98.1443H104.144C104.466 98.1443 104.727 97.8831 104.727 97.5609V80.8739C104.727 80.5518 104.466 80.2906 104.144 80.2906H91.927V22.9284C91.927 22.6062 91.6658 22.345 91.3436 22.345H68.9062C68.722 22.345 68.5485 22.4321 68.4384 22.5798L26.8871 78.3462C26.812 78.4469 26.7715 78.5691 26.7715 78.6947V97.5609C26.7715 97.8831 27.0327 98.1443 27.3548 98.1443H73.3458Z"/>
			<path d="M133.447 70.1054C133.447 68.4537 133.447 66.4809 133.447 64.187C133.539 61.8012 133.723 59.3696 133.998 56.8921C134.273 54.4147 134.732 51.9831 135.374 49.5973C136.017 47.1198 136.888 44.9176 137.989 42.9907C139.182 41.0638 140.65 39.5039 142.394 38.311C144.229 37.1182 146.477 36.5217 149.138 36.5217C151.799 36.5217 154.047 37.1182 155.882 38.311C157.718 39.5039 159.232 41.0638 160.424 42.9907C161.617 44.9176 162.489 47.1198 163.04 49.5973C163.682 51.9831 164.141 54.4147 164.416 56.8921C164.783 59.3696 164.966 61.8012 164.966 64.187C165.058 66.4809 165.104 68.4537 165.104 70.1054C165.104 72.8581 165.012 76.2073 164.829 80.153C164.645 84.0068 164.049 87.7689 163.04 91.4393C162.122 95.0178 160.562 98.0918 158.36 100.661C156.249 103.23 153.175 104.515 149.138 104.515C145.192 104.515 142.164 103.23 140.054 100.661C137.944 98.0918 136.384 95.0178 135.374 91.4393C134.457 87.7689 133.906 84.0068 133.723 80.153C133.539 76.2073 133.447 72.8581 133.447 70.1054ZM113.903 70.1054C113.903 79.74 114.82 87.8148 116.656 94.3297C118.582 100.753 121.152 105.891 124.363 109.745C127.575 113.599 131.291 116.352 135.512 118.003C139.825 119.655 144.367 120.481 149.138 120.481C154.001 120.481 158.543 119.655 162.764 118.003C167.077 116.352 170.839 113.599 174.051 109.745C177.354 105.891 179.923 100.753 181.758 94.3297C183.685 87.8148 184.649 79.74 184.649 70.1054C184.649 60.746 183.685 52.9006 181.758 46.5693C179.923 40.1462 177.354 35.0077 174.051 31.1538C170.839 27.3 167.077 24.5472 162.764 22.8956C158.543 21.2439 154.001 20.4181 149.138 20.4181C144.367 20.4181 139.825 21.2439 135.512 22.8956C131.291 24.5472 127.575 27.3 124.363 31.1538C121.152 35.0077 118.582 40.1462 116.656 46.5693C114.82 52.9006 113.903 60.746 113.903 70.1054Z"/>
			<path d="M240.107 46.8446V80.2906H214.781L239.694 46.8446H240.107ZM240.107 98.1443V118.108C240.107 118.43 240.368 118.692 240.69 118.692H258.105C258.427 118.692 258.688 118.43 258.688 118.108V98.1443H270.905C271.227 98.1443 271.488 97.8831 271.488 97.5609V80.8739C271.488 80.5518 271.227 80.2906 270.905 80.2906H258.688V22.9284C258.688 22.6062 258.427 22.345 258.105 22.345H235.667C235.483 22.345 235.31 22.4321 235.199 22.5798L193.648 78.3462C193.573 78.4469 193.532 78.5691 193.532 78.6947V97.5609C193.532 97.8831 193.794 98.1443 194.116 98.1443H240.107Z"/>
			</mask>
			<path d="M73.3458 46.8446V80.2906H48.0205L72.9329 46.8446H73.3458ZM73.3458 98.1443V118.108C73.3458 118.43 73.607 118.692 73.9292 118.692H91.3436C91.6658 118.692 91.927 118.43 91.927 118.108V98.1443H104.144C104.466 98.1443 104.727 97.8831 104.727 97.5609V80.8739C104.727 80.5518 104.466 80.2906 104.144 80.2906H91.927V22.9284C91.927 22.6062 91.6658 22.345 91.3436 22.345H68.9062C68.722 22.345 68.5485 22.4321 68.4384 22.5798L26.8871 78.3462C26.812 78.4469 26.7715 78.5691 26.7715 78.6947V97.5609C26.7715 97.8831 27.0327 98.1443 27.3548 98.1443H73.3458Z" fill="#385DFF" fill-opacity="0.2"/>
			<path d="M133.447 70.1054C133.447 68.4537 133.447 66.4809 133.447 64.187C133.539 61.8012 133.723 59.3696 133.998 56.8921C134.273 54.4147 134.732 51.9831 135.374 49.5973C136.017 47.1198 136.888 44.9176 137.989 42.9907C139.182 41.0638 140.65 39.5039 142.394 38.311C144.229 37.1182 146.477 36.5217 149.138 36.5217C151.799 36.5217 154.047 37.1182 155.882 38.311C157.718 39.5039 159.232 41.0638 160.424 42.9907C161.617 44.9176 162.489 47.1198 163.04 49.5973C163.682 51.9831 164.141 54.4147 164.416 56.8921C164.783 59.3696 164.966 61.8012 164.966 64.187C165.058 66.4809 165.104 68.4537 165.104 70.1054C165.104 72.8581 165.012 76.2073 164.829 80.153C164.645 84.0068 164.049 87.7689 163.04 91.4393C162.122 95.0178 160.562 98.0918 158.36 100.661C156.249 103.23 153.175 104.515 149.138 104.515C145.192 104.515 142.164 103.23 140.054 100.661C137.944 98.0918 136.384 95.0178 135.374 91.4393C134.457 87.7689 133.906 84.0068 133.723 80.153C133.539 76.2073 133.447 72.8581 133.447 70.1054ZM113.903 70.1054C113.903 79.74 114.82 87.8148 116.656 94.3297C118.582 100.753 121.152 105.891 124.363 109.745C127.575 113.599 131.291 116.352 135.512 118.003C139.825 119.655 144.367 120.481 149.138 120.481C154.001 120.481 158.543 119.655 162.764 118.003C167.077 116.352 170.839 113.599 174.051 109.745C177.354 105.891 179.923 100.753 181.758 94.3297C183.685 87.8148 184.649 79.74 184.649 70.1054C184.649 60.746 183.685 52.9006 181.758 46.5693C179.923 40.1462 177.354 35.0077 174.051 31.1538C170.839 27.3 167.077 24.5472 162.764 22.8956C158.543 21.2439 154.001 20.4181 149.138 20.4181C144.367 20.4181 139.825 21.2439 135.512 22.8956C131.291 24.5472 127.575 27.3 124.363 31.1538C121.152 35.0077 118.582 40.1462 116.656 46.5693C114.82 52.9006 113.903 60.746 113.903 70.1054Z" fill="#385DFF" fill-opacity="0.2"/>
			<path d="M240.107 46.8446V80.2906H214.781L239.694 46.8446H240.107ZM240.107 98.1443V118.108C240.107 118.43 240.368 118.692 240.69 118.692H258.105C258.427 118.692 258.688 118.43 258.688 118.108V98.1443H270.905C271.227 98.1443 271.488 97.8831 271.488 97.5609V80.8739C271.488 80.5518 271.227 80.2906 270.905 80.2906H258.688V22.9284C258.688 22.6062 258.427 22.345 258.105 22.345H235.667C235.483 22.345 235.31 22.4321 235.199 22.5798L193.648 78.3462C193.573 78.4469 193.532 78.5691 193.532 78.6947V97.5609C193.532 97.8831 193.794 98.1443 194.116 98.1443H240.107Z" fill="#385DFF" fill-opacity="0.2"/>
			<path d="M73.3458 46.8446H74.2209V45.9695H73.3458V46.8446ZM73.3458 80.2906V81.1656H74.2209V80.2906H73.3458ZM48.0205 80.2906L47.3187 79.7679L46.2776 81.1656H48.0205V80.2906ZM72.9329 46.8446V45.9695H72.4936L72.2312 46.3219L72.9329 46.8446ZM73.3458 98.1443H74.2209V97.2693H73.3458V98.1443ZM91.927 98.1443V97.2693H91.0519V98.1443H91.927ZM91.927 80.2906H91.0519V81.1656H91.927V80.2906ZM133.447 64.187L132.573 64.1533L132.572 64.1701V64.187H133.447ZM133.998 56.8921L134.868 56.9888L133.998 56.8921ZM135.374 49.5973L136.219 49.8248L136.221 49.8169L135.374 49.5973ZM137.989 42.9907L137.245 42.5301L137.237 42.5432L137.23 42.5566L137.989 42.9907ZM142.394 38.311L141.917 37.5774L141.908 37.583L141.9 37.5888L142.394 38.311ZM155.882 38.311L156.359 37.5774L155.882 38.311ZM160.424 42.9907L159.68 43.4513L160.424 42.9907ZM163.04 49.5973L162.185 49.7871L162.19 49.8061L162.195 49.8248L163.04 49.5973ZM164.416 56.8921L163.546 56.9888L163.548 57.0046L163.55 57.0204L164.416 56.8921ZM164.966 64.187H164.091V64.2044L164.092 64.2219L164.966 64.187ZM164.829 80.153L165.703 80.1946L165.703 80.1936L164.829 80.153ZM163.04 91.4393L162.196 91.2072L162.194 91.2146L162.192 91.2219L163.04 91.4393ZM158.36 100.661L157.695 100.092L157.689 100.098L157.684 100.106L158.36 100.661ZM140.054 100.661L140.73 100.106L140.054 100.661ZM135.374 91.4393L134.525 91.6515L134.529 91.6642L134.532 91.6768L135.374 91.4393ZM133.723 80.153L132.849 80.1936L132.849 80.1946L133.723 80.153ZM116.656 94.3297L115.813 94.5669L115.815 94.574L115.817 94.5811L116.656 94.3297ZM124.363 109.745L125.035 109.185L124.363 109.745ZM135.512 118.003L135.193 118.818L135.199 118.821L135.512 118.003ZM162.764 118.003L162.451 117.186L162.445 117.189L162.764 118.003ZM174.051 109.745L173.386 109.176L173.378 109.185L174.051 109.745ZM181.758 94.3297L180.919 94.0815L180.917 94.0893L181.758 94.3297ZM181.758 46.5693L180.917 46.8097L180.919 46.8169L180.921 46.8241L181.758 46.5693ZM174.051 31.1538L173.378 31.7141L173.386 31.7233L174.051 31.1538ZM162.764 22.8956L162.445 23.7105L162.451 23.7127L162.764 22.8956ZM135.512 22.8956L135.199 22.0784L135.193 22.0807L135.512 22.8956ZM124.363 31.1538L125.035 31.714V31.714L124.363 31.1538ZM116.656 46.5693L115.817 46.3178L115.815 46.3257L116.656 46.5693ZM240.107 46.8446H240.982V45.9695H240.107V46.8446ZM240.107 80.2906V81.1656H240.982V80.2906H240.107ZM214.781 80.2906L214.08 79.7679L213.039 81.1656H214.781V80.2906ZM239.694 46.8446V45.9695H239.255L238.992 46.3219L239.694 46.8446ZM240.107 98.1443H240.982V97.2693H240.107V98.1443ZM258.688 98.1443V97.2693H257.813V98.1443H258.688ZM258.688 80.2906H257.813V81.1656H258.688V80.2906ZM193.648 78.3462L194.35 78.869L193.648 78.3462ZM235.199 22.5798L234.498 22.057L235.199 22.5798ZM26.8871 78.3462L27.5887 78.869L26.8871 78.3462ZM68.4384 22.5798L67.7368 22.057L68.4384 22.5798ZM72.4708 46.8446V80.2906H74.2209V46.8446H72.4708ZM73.3458 79.4156H48.0205V81.1656H73.3458V79.4156ZM48.7222 80.8133L73.6347 47.3673L72.2312 46.3219L47.3187 79.7679L48.7222 80.8133ZM72.9329 47.7196H73.3458V45.9695H72.9329V47.7196ZM72.4708 98.1443V118.108H74.2209V98.1443H72.4708ZM73.9292 119.567H91.3436V117.817H73.9292V119.567ZM92.802 118.108V98.1443H91.0519V118.108H92.802ZM91.927 99.0193H104.144V97.2693H91.927V99.0193ZM105.602 97.5609V80.8739H103.852V97.5609H105.602ZM104.144 79.4156H91.927V81.1656H104.144V79.4156ZM92.802 80.2906V22.9284H91.0519V80.2906H92.802ZM91.3436 21.47H68.9062V23.2201H91.3436V21.47ZM67.7368 22.057L26.1854 77.8234L27.5887 78.869L69.1401 23.1026L67.7368 22.057ZM25.8965 78.6947V97.5609H27.6465V78.6947H25.8965ZM27.3548 99.0193H73.3458V97.2693H27.3548V99.0193ZM134.322 70.1054C134.322 70.1022 134.322 70.0989 134.322 70.0957C134.322 70.0925 134.322 70.0892 134.322 70.086C134.322 70.0828 134.322 70.0795 134.322 70.0763C134.322 70.0731 134.322 70.0698 134.322 70.0666C134.322 70.0634 134.322 70.0601 134.322 70.0569C134.322 70.0537 134.322 70.0504 134.322 70.0472C134.322 70.0439 134.322 70.0407 134.322 70.0375C134.322 70.0342 134.322 70.031 134.322 70.0277C134.322 70.0245 134.322 70.0212 134.322 70.018C134.322 70.0147 134.322 70.0115 134.322 70.0082C134.322 70.005 134.322 70.0017 134.322 69.9985C134.322 69.9952 134.322 69.992 134.322 69.9887C134.322 69.9855 134.322 69.9822 134.322 69.979C134.322 69.9757 134.322 69.9724 134.322 69.9692C134.322 69.9659 134.322 69.9627 134.322 69.9594C134.322 69.9561 134.322 69.9529 134.322 69.9496C134.322 69.9463 134.322 69.9431 134.322 69.9398C134.322 69.9365 134.322 69.9333 134.322 69.93C134.322 69.9267 134.322 69.9235 134.322 69.9202C134.322 69.9169 134.322 69.9136 134.322 69.9104C134.322 69.9071 134.322 69.9038 134.322 69.9005C134.322 69.8973 134.322 69.894 134.322 69.8907C134.322 69.8874 134.322 69.8841 134.322 69.8808C134.322 69.8776 134.322 69.8743 134.322 69.871C134.322 69.8677 134.322 69.8644 134.322 69.8611C134.322 69.8579 134.322 69.8546 134.322 69.8513C134.322 69.848 134.322 69.8447 134.322 69.8414C134.322 69.8381 134.322 69.8348 134.322 69.8315C134.322 69.8282 134.322 69.8249 134.322 69.8216C134.322 69.8183 134.322 69.815 134.322 69.8117C134.322 69.8084 134.322 69.8051 134.322 69.8018C134.322 69.7985 134.322 69.7952 134.322 69.7919C134.322 69.7886 134.322 69.7853 134.322 69.782C134.322 69.7787 134.322 69.7754 134.322 69.7721C134.322 69.7688 134.322 69.7655 134.322 69.7622C134.322 69.7588 134.322 69.7555 134.322 69.7522C134.322 69.7489 134.322 69.7456 134.322 69.7423C134.322 69.739 134.322 69.7356 134.322 69.7323C134.322 69.729 134.322 69.7257 134.322 69.7224C134.322 69.719 134.322 69.7157 134.322 69.7124C134.322 69.7091 134.322 69.7057 134.322 69.7024C134.322 69.6991 134.322 69.6958 134.322 69.6924C134.322 69.6891 134.322 69.6858 134.322 69.6824C134.322 69.6791 134.322 69.6758 134.322 69.6724C134.322 69.6691 134.322 69.6658 134.322 69.6624C134.322 69.6591 134.322 69.6558 134.322 69.6524C134.322 69.6491 134.322 69.6458 134.322 69.6424C134.322 69.6391 134.322 69.6357 134.322 69.6324C134.322 69.629 134.322 69.6257 134.322 69.6223C134.322 69.619 134.322 69.6157 134.322 69.6123C134.322 69.609 134.322 69.6056 134.322 69.6023C134.322 69.5989 134.322 69.5956 134.322 69.5922C134.322 69.5888 134.322 69.5855 134.322 69.5821C134.322 69.5788 134.322 69.5754 134.322 69.5721C134.322 69.5687 134.322 69.5653 134.322 69.562C134.322 69.5586 134.322 69.5553 134.322 69.5519C134.322 69.5485 134.322 69.5452 134.322 69.5418C134.322 69.5384 134.322 69.5351 134.322 69.5317C134.322 69.5283 134.322 69.525 134.322 69.5216C134.322 69.5182 134.322 69.5149 134.322 69.5115C134.322 69.5081 134.322 69.5047 134.322 69.5014C134.322 69.498 134.322 69.4946 134.322 69.4912C134.322 69.4879 134.322 69.4845 134.322 69.4811C134.322 69.4777 134.322 69.4743 134.322 69.471C134.322 69.4676 134.322 69.4642 134.322 69.4608C134.322 69.4574 134.322 69.454 134.322 69.4506C134.322 69.4473 134.322 69.4439 134.322 69.4405C134.322 69.4371 134.322 69.4337 134.322 69.4303C134.322 69.4269 134.322 69.4235 134.322 69.4201C134.322 69.4167 134.322 69.4133 134.322 69.4099C134.322 69.4065 134.322 69.4031 134.322 69.3997C134.322 69.3963 134.322 69.3929 134.322 69.3895C134.322 69.3861 134.322 69.3827 134.322 69.3793C134.322 69.3759 134.322 69.3725 134.322 69.3691C134.322 69.3657 134.322 69.3623 134.322 69.3589C134.322 69.3555 134.322 69.3521 134.322 69.3486C134.322 69.3452 134.322 69.3418 134.322 69.3384C134.322 69.335 134.322 69.3316 134.322 69.3282C134.322 69.3247 134.322 69.3213 134.322 69.3179C134.322 69.3145 134.322 69.3111 134.322 69.3076C134.322 69.3042 134.322 69.3008 134.322 69.2974C134.322 69.2939 134.322 69.2905 134.322 69.2871C134.322 69.2837 134.322 69.2802 134.322 69.2768C134.322 69.2734 134.322 69.27 134.322 69.2665C134.322 69.2631 134.322 69.2597 134.322 69.2562C134.322 69.2528 134.322 69.2494 134.322 69.2459C134.322 69.2425 134.322 69.239 134.322 69.2356C134.322 69.2322 134.322 69.2287 134.322 69.2253C134.322 69.2218 134.322 69.2184 134.322 69.215C134.322 69.2115 134.322 69.2081 134.322 69.2046C134.322 69.2012 134.322 69.1977 134.322 69.1943C134.322 69.1908 134.322 69.1874 134.322 69.1839C134.322 69.1805 134.322 69.177 134.322 69.1736C134.322 69.1701 134.322 69.1667 134.322 69.1632C134.322 69.1597 134.322 69.1563 134.322 69.1528C134.322 69.1494 134.322 69.1459 134.322 69.1425C134.322 69.139 134.322 69.1355 134.322 69.1321C134.322 69.1286 134.322 69.1251 134.322 69.1217C134.322 69.1182 134.322 69.1147 134.322 69.1113C134.322 69.1078 134.322 69.1043 134.322 69.1009C134.322 69.0974 134.322 69.0939 134.322 69.0904C134.322 69.087 134.322 69.0835 134.322 69.08C134.322 69.0765 134.322 69.0731 134.322 69.0696C134.322 69.0661 134.322 69.0626 134.322 69.0592C134.322 69.0557 134.322 69.0522 134.322 69.0487C134.322 69.0452 134.322 69.0417 134.322 69.0382C134.322 69.0348 134.322 69.0313 134.322 69.0278C134.322 69.0243 134.322 69.0208 134.322 69.0173C134.322 69.0138 134.322 69.0103 134.322 69.0068C134.322 69.0034 134.322 68.9999 134.322 68.9964C134.322 68.9929 134.322 68.9894 134.322 68.9859C134.322 68.9824 134.322 68.9789 134.322 68.9754C134.322 68.9719 134.322 68.9684 134.322 68.9649C134.322 68.9614 134.322 68.9579 134.322 68.9544C134.322 68.9509 134.322 68.9473 134.322 68.9438C134.322 68.9403 134.322 68.9368 134.322 68.9333C134.322 68.9298 134.322 68.9263 134.322 68.9228C134.322 68.9193 134.322 68.9158 134.322 68.9122C134.322 68.9087 134.322 68.9052 134.322 68.9017C134.322 68.8982 134.322 68.8947 134.322 68.8911C134.322 68.8876 134.322 68.8841 134.322 68.8806C134.322 68.877 134.322 68.8735 134.322 68.87C134.322 68.8665 134.322 68.8629 134.322 68.8594C134.322 68.8559 134.322 68.8524 134.322 68.8488C134.322 68.8453 134.322 68.8418 134.322 68.8382C134.322 68.8347 134.322 68.8312 134.322 68.8276C134.322 68.8241 134.322 68.8206 134.322 68.817C134.322 68.8135 134.322 68.81 134.322 68.8064C134.322 68.8029 134.322 68.7993 134.322 68.7958C134.322 68.7923 134.322 68.7887 134.322 68.7852C134.322 68.7816 134.322 68.7781 134.322 68.7745C134.322 68.771 134.322 68.7674 134.322 68.7639C134.322 68.7603 134.322 68.7568 134.322 68.7532C134.322 68.7497 134.322 68.7461 134.322 68.7426C134.322 68.739 134.322 68.7355 134.322 68.7319C134.322 68.7284 134.322 68.7248 134.322 68.7212C134.322 68.7177 134.322 68.7141 134.322 68.7106C134.322 68.707 134.322 68.7034 134.322 68.6999C134.322 68.6963 134.322 68.6927 134.322 68.6892C134.322 68.6856 134.322 68.682 134.322 68.6785C134.322 68.6749 134.322 68.6713 134.322 68.6678C134.322 68.6642 134.322 68.6606 134.322 68.657C134.322 68.6535 134.322 68.6499 134.322 68.6463C134.322 68.6427 134.322 68.6392 134.322 68.6356C134.322 68.632 134.322 68.6284 134.322 68.6248C134.322 68.6213 134.322 68.6177 134.322 68.6141C134.322 68.6105 134.322 68.6069 134.322 68.6033C134.322 68.5998 134.322 68.5962 134.322 68.5926C134.322 68.589 134.322 68.5854 134.322 68.5818C134.322 68.5782 134.322 68.5746 134.322 68.571C134.322 68.5674 134.322 68.5638 134.322 68.5603C134.322 68.5567 134.322 68.5531 134.322 68.5495C134.322 68.5459 134.322 68.5423 134.322 68.5387C134.322 68.5351 134.322 68.5315 134.322 68.5279C134.322 68.5243 134.322 68.5206 134.322 68.517C134.322 68.5134 134.322 68.5098 134.322 68.5062C134.322 68.5026 134.322 68.499 134.322 68.4954C134.322 68.4918 134.322 68.4882 134.322 68.4846C134.322 68.4809 134.322 68.4773 134.322 68.4737C134.322 68.4701 134.322 68.4665 134.322 68.4629C134.322 68.4592 134.322 68.4556 134.322 68.452C134.322 68.4484 134.322 68.4448 134.322 68.4411C134.322 68.4375 134.322 68.4339 134.322 68.4303C134.322 68.4266 134.322 68.423 134.322 68.4194C134.322 68.4158 134.322 68.4121 134.322 68.4085C134.322 68.4049 134.322 68.4012 134.322 68.3976C134.322 68.394 134.322 68.3903 134.322 68.3867C134.322 68.3831 134.322 68.3794 134.322 68.3758C134.322 68.3722 134.322 68.3685 134.322 68.3649C134.322 68.3612 134.322 68.3576 134.322 68.354C134.322 68.3503 134.322 68.3467 134.322 68.343C134.322 68.3394 134.322 68.3357 134.322 68.3321C134.322 68.3284 134.322 68.3248 134.322 68.3211C134.322 68.3175 134.322 68.3138 134.322 68.3102C134.322 68.3065 134.322 68.3029 134.322 68.2992C134.322 68.2956 134.322 68.2919 134.322 68.2883C134.322 68.2846 134.322 68.2809 134.322 68.2773C134.322 68.2736 134.322 68.27 134.322 68.2663C134.322 68.2626 134.322 68.259 134.322 68.2553C134.322 68.2517 134.322 68.248 134.322 68.2443C134.322 68.2407 134.322 68.237 134.322 68.2333C134.322 68.2296 134.322 68.226 134.322 68.2223C134.322 68.2186 134.322 68.215 134.322 68.2113C134.322 68.2076 134.322 68.2039 134.322 68.2003C134.322 68.1966 134.322 68.1929 134.322 68.1892C134.322 68.1855 134.322 68.1819 134.322 68.1782C134.322 68.1745 134.322 68.1708 134.322 68.1671C134.322 68.1635 134.322 68.1598 134.322 68.1561C134.322 68.1524 134.322 68.1487 134.322 68.145C134.322 68.1413 134.322 68.1376 134.322 68.1339C134.322 68.1303 134.322 68.1266 134.322 68.1229C134.322 68.1192 134.322 68.1155 134.322 68.1118C134.322 68.1081 134.322 68.1044 134.322 68.1007C134.322 68.097 134.322 68.0933 134.322 68.0896C134.322 68.0859 134.322 68.0822 134.322 68.0785C134.322 68.0748 134.322 68.0711 134.322 68.0674C134.322 68.0637 134.322 68.06 134.322 68.0562C134.322 68.0525 134.322 68.0488 134.322 68.0451C134.322 68.0414 134.322 68.0377 134.322 68.034C134.322 68.0303 134.322 68.0266 134.322 68.0228C134.322 68.0191 134.322 68.0154 134.322 68.0117C134.322 68.008 134.322 68.0042 134.322 68.0005C134.322 67.9968 134.322 67.9931 134.322 67.9894C134.322 67.9856 134.322 67.9819 134.322 67.9782C134.322 67.9745 134.322 67.9707 134.322 67.967C134.322 67.9633 134.322 67.9595 134.322 67.9558C134.322 67.9521 134.322 67.9484 134.322 67.9446C134.322 67.9409 134.322 67.9372 134.322 67.9334C134.322 67.9297 134.322 67.9259 134.322 67.9222C134.322 67.9185 134.322 67.9147 134.322 67.911C134.322 67.9072 134.322 67.9035 134.322 67.8998C134.322 67.896 134.322 67.8923 134.322 67.8885C134.322 67.8848 134.322 67.881 134.322 67.8773C134.322 67.8735 134.322 67.8698 134.322 67.866C134.322 67.8623 134.322 67.8585 134.322 67.8548C134.322 67.851 134.322 67.8473 134.322 67.8435C134.322 67.8398 134.322 67.836 134.322 67.8323C134.322 67.8285 134.322 67.8247 134.322 67.821C134.322 67.8172 134.322 67.8135 134.322 67.8097C134.322 67.8059 134.322 67.8022 134.322 67.7984C134.322 67.7946 134.322 67.7909 134.322 67.7871C134.322 67.7833 134.322 67.7796 134.322 67.7758C134.322 67.772 134.322 67.7683 134.322 67.7645C134.322 67.7607 134.322 67.7569 134.322 67.7532C134.322 67.7494 134.322 67.7456 134.322 67.7418C134.322 67.7381 134.322 67.7343 134.322 67.7305C134.322 67.7267 134.322 67.7229 134.322 67.7192C134.322 67.7154 134.322 67.7116 134.322 67.7078C134.322 67.704 134.322 67.7002 134.322 67.6965C134.322 67.6927 134.322 67.6889 134.322 67.6851C134.322 67.6813 134.322 67.6775 134.322 67.6737C134.322 67.6699 134.322 67.6661 134.322 67.6623C134.322 67.6585 134.322 67.6548 134.322 67.651C134.322 67.6472 134.322 67.6434 134.322 67.6396C134.322 67.6358 134.322 67.632 134.322 67.6282C134.322 67.6244 134.322 67.6206 134.322 67.6168C134.322 67.6129 134.322 67.6091 134.322 67.6053C134.322 67.6015 134.322 67.5977 134.322 67.5939C134.322 67.5901 134.322 67.5863 134.322 67.5825C134.322 67.5787 134.322 67.5749 134.322 67.571C134.322 67.5672 134.322 67.5634 134.322 67.5596C134.322 67.5558 134.322 67.552 134.322 67.5481C134.322 67.5443 134.322 67.5405 134.322 67.5367C134.322 67.5329 134.322 67.529 134.322 67.5252C134.322 67.5214 134.322 67.5176 134.322 67.5137C134.322 67.5099 134.322 67.5061 134.322 67.5023C134.322 67.4984 134.322 67.4946 134.322 67.4908C134.322 67.4869 134.322 67.4831 134.322 67.4793C134.322 67.4754 134.322 67.4716 134.322 67.4678C134.322 67.4639 134.322 67.4601 134.322 67.4563C134.322 67.4524 134.322 67.4486 134.322 67.4447C134.322 67.4409 134.322 67.4371 134.322 67.4332C134.322 67.4294 134.322 67.4255 134.322 67.4217C134.322 67.4178 134.322 67.414 134.322 67.4101C134.322 67.4063 134.322 67.4024 134.322 67.3986C134.322 67.3947 134.322 67.3909 134.322 67.387C134.322 67.3832 134.322 67.3793 134.322 67.3755C134.322 67.3716 134.322 67.3678 134.322 67.3639C134.322 67.36 134.322 67.3562 134.322 67.3523C134.322 67.3485 134.322 67.3446 134.322 67.3407C134.322 67.3369 134.322 67.333 134.322 67.3291C134.322 67.3253 134.322 67.3214 134.322 67.3175C134.322 67.3137 134.322 67.3098 134.322 67.3059C134.322 67.3021 134.322 67.2982 134.322 67.2943C134.322 67.2905 134.322 67.2866 134.322 67.2827C134.322 67.2788 134.322 67.2749 134.322 67.2711C134.322 67.2672 134.322 67.2633 134.322 67.2594C134.322 67.2556 134.322 67.2517 134.322 67.2478C134.322 67.2439 134.322 67.24 134.322 67.2361C134.322 67.2323 134.322 67.2284 134.322 67.2245C134.322 67.2206 134.322 67.2167 134.322 67.2128C134.322 67.2089 134.322 67.205 134.322 67.2011C134.322 67.1973 134.322 67.1934 134.322 67.1895C134.322 67.1856 134.322 67.1817 134.322 67.1778C134.322 67.1739 134.322 67.17 134.322 67.1661C134.322 67.1622 134.322 67.1583 134.322 67.1544C134.322 67.1505 134.322 67.1466 134.322 67.1427C134.322 67.1388 134.322 67.1349 134.322 67.1309C134.322 67.127 134.322 67.1231 134.322 67.1192C134.322 67.1153 134.322 67.1114 134.322 67.1075C134.322 67.1036 134.322 67.0997 134.322 67.0957C134.322 67.0918 134.322 67.0879 134.322 67.084C134.322 67.0801 134.322 67.0762 134.322 67.0723C134.322 67.0683 134.322 67.0644 134.322 67.0605C134.322 67.0566 134.322 67.0526 134.322 67.0487C134.322 67.0448 134.322 67.0409 134.322 67.0369C134.322 67.033 134.322 67.0291 134.322 67.0252C134.322 67.0212 134.322 67.0173 134.322 67.0134C134.322 67.0094 134.322 67.0055 134.322 67.0016C134.322 66.9976 134.322 66.9937 134.322 66.9898C134.322 66.9858 134.322 66.9819 134.322 66.978C134.322 66.974 134.322 66.9701 134.322 66.9661C134.322 66.9622 134.322 66.9582 134.322 66.9543C134.322 66.9504 134.322 66.9464 134.322 66.9425C134.322 66.9385 134.322 66.9346 134.322 66.9306C134.322 66.9267 134.322 66.9227 134.322 66.9188C134.322 66.9148 134.322 66.9109 134.322 66.9069C134.322 66.903 134.322 66.899 134.322 66.8951C134.322 66.8911 134.322 66.8871 134.322 66.8832C134.322 66.8792 134.322 66.8753 134.322 66.8713C134.322 66.8673 134.322 66.8634 134.322 66.8594C134.322 66.8555 134.322 66.8515 134.322 66.8475C134.322 66.8436 134.322 66.8396 134.322 66.8356C134.322 66.8317 134.322 66.8277 134.322 66.8237C134.322 66.8197 134.322 66.8158 134.322 66.8118C134.322 66.8078 134.322 66.8038 134.322 66.7999C134.322 66.7959 134.322 66.7919 134.322 66.7879C134.322 66.784 134.322 66.78 134.322 66.776C134.322 66.772 134.322 66.768 134.322 66.7641C134.322 66.7601 134.322 66.7561 134.322 66.7521C134.322 66.7481 134.322 66.7441 134.322 66.7401C134.322 66.7362 134.322 66.7322 134.322 66.7282C134.322 66.7242 134.322 66.7202 134.322 66.7162C134.322 66.7122 134.322 66.7082 134.322 66.7042C134.322 66.7002 134.322 66.6962 134.322 66.6922C134.322 66.6882 134.322 66.6842 134.322 66.6802C134.322 66.6762 134.322 66.6722 134.322 66.6682C134.322 66.6642 134.322 66.6602 134.322 66.6562C134.322 66.6522 134.322 66.6482 134.322 66.6442C134.322 66.6402 134.322 66.6362 134.322 66.6322C134.322 66.6282 134.322 66.6242 134.322 66.6201C134.322 66.6161 134.322 66.6121 134.322 66.6081C134.322 66.6041 134.322 66.6001 134.322 66.5961C134.322 66.592 134.322 66.588 134.322 66.584C134.322 66.58 134.322 66.576 134.322 66.5719C134.322 66.5679 134.322 66.5639 134.322 66.5599C134.322 66.5558 134.322 66.5518 134.322 66.5478C134.322 66.5438 134.322 66.5397 134.322 66.5357C134.322 66.5317 134.322 66.5276 134.322 66.5236C134.322 66.5196 134.322 66.5155 134.322 66.5115C134.322 66.5075 134.322 66.5034 134.322 66.4994C134.322 66.4954 134.322 66.4913 134.322 66.4873C134.322 66.4832 134.322 66.4792 134.322 66.4752C134.322 66.4711 134.322 66.4671 134.322 66.463C134.322 66.459 134.322 66.4549 134.322 66.4509C134.322 66.4469 134.322 66.4428 134.322 66.4388C134.322 66.4347 134.322 66.4307 134.322 66.4266C134.322 66.4226 134.322 66.4185 134.322 66.4144C134.322 66.4104 134.322 66.4063 134.322 66.4023C134.322 66.3982 134.322 66.3942 134.322 66.3901C134.322 66.3861 134.322 66.382 134.322 66.3779C134.322 66.3739 134.322 66.3698 134.322 66.3657C134.322 66.3617 134.322 66.3576 134.322 66.3535C134.322 66.3495 134.322 66.3454 134.322 66.3413C134.322 66.3373 134.322 66.3332 134.322 66.3291C134.322 66.3251 134.322 66.321 134.322 66.3169C134.322 66.3128 134.322 66.3088 134.322 66.3047C134.322 66.3006 134.322 66.2965 134.322 66.2925C134.322 66.2884 134.322 66.2843 134.322 66.2802C134.322 66.2761 134.322 66.2721 134.322 66.268C134.322 66.2639 134.322 66.2598 134.322 66.2557C134.322 66.2516 134.322 66.2475 134.322 66.2435C134.322 66.2394 134.322 66.2353 134.322 66.2312C134.322 66.2271 134.322 66.223 134.322 66.2189C134.322 66.2148 134.322 66.2107 134.322 66.2066C134.322 66.2025 134.322 66.1984 134.322 66.1943C134.322 66.1902 134.322 66.1861 134.322 66.182C134.322 66.1779 134.322 66.1738 134.322 66.1697C134.322 66.1656 134.322 66.1615 134.322 66.1574C134.322 66.1533 134.322 66.1492 134.322 66.1451C134.322 66.141 134.322 66.1369 134.322 66.1328C134.322 66.1287 134.322 66.1245 134.322 66.1204C134.322 66.1163 134.322 66.1122 134.322 66.1081C134.322 66.104 134.322 66.0999 134.322 66.0957C134.322 66.0916 134.322 66.0875 134.322 66.0834C134.322 66.0793 134.322 66.0751 134.322 66.071C134.322 66.0669 134.322 66.0628 134.322 66.0587C134.322 66.0545 134.322 66.0504 134.322 66.0463C134.322 66.0421 134.322 66.038 134.322 66.0339C134.322 66.0298 134.322 66.0256 134.322 66.0215C134.322 66.0174 134.322 66.0132 134.322 66.0091C134.322 66.005 134.322 66.0008 134.322 65.9967C134.322 65.9925 134.322 65.9884 134.322 65.9843C134.322 65.9801 134.322 65.976 134.322 65.9718C134.322 65.9677 134.322 65.9636 134.322 65.9594C134.322 65.9553 134.322 65.9511 134.322 65.947C134.322 65.9428 134.322 65.9387 134.322 65.9345C134.322 65.9304 134.322 65.9262 134.322 65.9221C134.322 65.9179 134.322 65.9138 134.322 65.9096C134.322 65.9055 134.322 65.9013 134.322 65.8972C134.322 65.893 134.322 65.8888 134.322 65.8847C134.322 65.8805 134.322 65.8764 134.322 65.8722C134.322 65.868 134.322 65.8639 134.322 65.8597C134.322 65.8555 134.322 65.8514 134.322 65.8472C134.322 65.843 134.322 65.8389 134.322 65.8347C134.322 65.8305 134.322 65.8264 134.322 65.8222C134.322 65.818 134.322 65.8139 134.322 65.8097C134.322 65.8055 134.322 65.8013 134.322 65.7971C134.322 65.793 134.322 65.7888 134.322 65.7846C134.322 65.7804 134.322 65.7763 134.322 65.7721C134.322 65.7679 134.322 65.7637 134.322 65.7595C134.322 65.7553 134.322 65.7512 134.322 65.747C134.322 65.7428 134.322 65.7386 134.322 65.7344C134.322 65.7302 134.322 65.726 134.322 65.7218C134.322 65.7176 134.322 65.7135 134.322 65.7093C134.322 65.7051 134.322 65.7009 134.322 65.6967C134.322 65.6925 134.322 65.6883 134.322 65.6841C134.322 65.6799 134.322 65.6757 134.322 65.6715C134.322 65.6673 134.322 65.6631 134.322 65.6589C134.322 65.6547 134.322 65.6505 134.322 65.6463C134.322 65.6421 134.322 65.6379 134.322 65.6336C134.322 65.6294 134.322 65.6252 134.322 65.621C134.322 65.6168 134.322 65.6126 134.322 65.6084C134.322 65.6042 134.322 65.5999 134.322 65.5957C134.322 65.5915 134.322 65.5873 134.322 65.5831C134.322 65.5789 134.322 65.5746 134.322 65.5704C134.322 65.5662 134.322 65.562 134.322 65.5578C134.322 65.5535 134.322 65.5493 134.322 65.5451C134.322 65.5409 134.322 65.5366 134.322 65.5324C134.322 65.5282 134.322 65.5239 134.322 65.5197C134.322 65.5155 134.322 65.5113 134.322 65.507C134.322 65.5028 134.322 65.4986 134.322 65.4943C134.322 65.4901 134.322 65.4858 134.322 65.4816C134.322 65.4774 134.322 65.4731 134.322 65.4689C134.322 65.4647 134.322 65.4604 134.322 65.4562C134.322 65.4519 134.322 65.4477 134.322 65.4434C134.322 65.4392 134.322 65.4349 134.322 65.4307C134.322 65.4264 134.322 65.4222 134.322 65.4179C134.322 65.4137 134.322 65.4095 134.322 65.4052C134.322 65.4009 134.322 65.3967 134.322 65.3924C134.322 65.3882 134.322 65.3839 134.322 65.3797C134.322 65.3754 134.322 65.3712 134.322 65.3669C134.322 65.3626 134.322 65.3584 134.322 65.3541C134.322 65.3498 134.322 65.3456 134.322 65.3413C134.322 65.3371 134.322 65.3328 134.322 65.3285C134.322 65.3243 134.322 65.32 134.322 65.3157C134.322 65.3114 134.322 65.3072 134.322 65.3029C134.322 65.2986 134.322 65.2944 134.322 65.2901C134.322 65.2858 134.322 65.2815 134.322 65.2773C134.322 65.273 134.322 65.2687 134.322 65.2644C134.322 65.2601 134.322 65.2559 134.322 65.2516C134.322 65.2473 134.322 65.243 134.322 65.2387C134.322 65.2344 134.322 65.2302 134.322 65.2259C134.322 65.2216 134.322 65.2173 134.322 65.213C134.322 65.2087 134.322 65.2044 134.322 65.2001C134.322 65.1958 134.322 65.1916 134.322 65.1873C134.322 65.183 134.322 65.1787 134.322 65.1744C134.322 65.1701 134.322 65.1658 134.322 65.1615C134.322 65.1572 134.322 65.1529 134.322 65.1486C134.322 65.1443 134.322 65.14 134.322 65.1357C134.322 65.1314 134.322 65.1271 134.322 65.1228C134.322 65.1184 134.322 65.1141 134.322 65.1098C134.322 65.1055 134.322 65.1012 134.322 65.0969C134.322 65.0926 134.322 65.0883 134.322 65.084C134.322 65.0796 134.322 65.0753 134.322 65.071C134.322 65.0667 134.322 65.0624 134.322 65.0581C134.322 65.0537 134.322 65.0494 134.322 65.0451C134.322 65.0408 134.322 65.0365 134.322 65.0321C134.322 65.0278 134.322 65.0235 134.322 65.0192C134.322 65.0148 134.322 65.0105 134.322 65.0062C134.322 65.0019 134.322 64.9975 134.322 64.9932C134.322 64.9889 134.322 64.9845 134.322 64.9802C134.322 64.9759 134.322 64.9715 134.322 64.9672C134.322 64.9629 134.322 64.9585 134.322 64.9542C134.322 64.9498 134.322 64.9455 134.322 64.9412C134.322 64.9368 134.322 64.9325 134.322 64.9281C134.322 64.9238 134.322 64.9194 134.322 64.9151C134.322 64.9108 134.322 64.9064 134.322 64.9021C134.322 64.8977 134.322 64.8934 134.322 64.889C134.322 64.8847 134.322 64.8803 134.322 64.876C134.322 64.8716 134.322 64.8673 134.322 64.8629C134.322 64.8585 134.322 64.8542 134.322 64.8498C134.322 64.8455 134.322 64.8411 134.322 64.8367C134.322 64.8324 134.322 64.828 134.322 64.8237C134.322 64.8193 134.322 64.8149 134.322 64.8106C134.322 64.8062 134.322 64.8018 134.322 64.7975C134.322 64.7931 134.322 64.7887 134.322 64.7844C134.322 64.78 134.322 64.7756 134.322 64.7713C134.322 64.7669 134.322 64.7625 134.322 64.7581C134.322 64.7538 134.322 64.7494 134.322 64.745C134.322 64.7406 134.322 64.7362 134.322 64.7319C134.322 64.7275 134.322 64.7231 134.322 64.7187C134.322 64.7143 134.322 64.71 134.322 64.7056C134.322 64.7012 134.322 64.6968 134.322 64.6924C134.322 64.688 134.322 64.6836 134.322 64.6792C134.322 64.6749 134.322 64.6705 134.322 64.6661C134.322 64.6617 134.322 64.6573 134.322 64.6529C134.322 64.6485 134.322 64.6441 134.322 64.6397C134.322 64.6353 134.322 64.6309 134.322 64.6265C134.322 64.6221 134.322 64.6177 134.322 64.6133C134.322 64.6089 134.322 64.6045 134.322 64.6001C134.322 64.5957 134.322 64.5913 134.322 64.5869C134.322 64.5825 134.322 64.5781 134.322 64.5737C134.322 64.5692 134.322 64.5648 134.322 64.5604C134.322 64.556 134.322 64.5516 134.322 64.5472C134.322 64.5428 134.322 64.5384 134.322 64.5339C134.322 64.5295 134.322 64.5251 134.322 64.5207C134.322 64.5163 134.322 64.5118 134.322 64.5074C134.322 64.503 134.322 64.4986 134.322 64.4942C134.322 64.4897 134.322 64.4853 134.322 64.4809C134.322 64.4765 134.322 64.472 134.322 64.4676C134.322 64.4632 134.322 64.4587 134.322 64.4543C134.322 64.4499 134.322 64.4454 134.322 64.441C134.322 64.4366 134.322 64.4321 134.322 64.4277C134.322 64.4233 134.322 64.4188 134.322 64.4144C134.322 64.41 134.322 64.4055 134.322 64.4011C134.322 64.3966 134.322 64.3922 134.322 64.3877C134.322 64.3833 134.322 64.3789 134.322 64.3744C134.322 64.37 134.322 64.3655 134.322 64.3611C134.322 64.3566 134.322 64.3522 134.322 64.3477C134.322 64.3433 134.322 64.3388 134.322 64.3344C134.322 64.3299 134.322 64.3255 134.322 64.321C134.322 64.3165 134.322 64.3121 134.322 64.3076C134.322 64.3032 134.322 64.2987 134.322 64.2942C134.322 64.2898 134.322 64.2853 134.322 64.2809C134.322 64.2764 134.322 64.2719 134.322 64.2675C134.322 64.263 134.322 64.2585 134.322 64.2541C134.322 64.2496 134.322 64.2451 134.322 64.2407C134.322 64.2362 134.322 64.2317 134.322 64.2272C134.322 64.2228 134.322 64.2183 134.322 64.2138C134.322 64.2093 134.322 64.2049 134.322 64.2004C134.322 64.1959 134.322 64.1914 134.322 64.187H132.572C132.572 64.1914 132.572 64.1959 132.572 64.2004C132.572 64.2049 132.572 64.2093 132.572 64.2138C132.572 64.2183 132.572 64.2228 132.572 64.2272C132.572 64.2317 132.572 64.2362 132.572 64.2407C132.572 64.2451 132.572 64.2496 132.572 64.2541C132.572 64.2585 132.572 64.263 132.572 64.2675C132.572 64.2719 132.572 64.2764 132.572 64.2809C132.572 64.2853 132.572 64.2898 132.572 64.2942C132.572 64.2987 132.572 64.3032 132.572 64.3076C132.572 64.3121 132.572 64.3165 132.572 64.321C132.572 64.3255 132.572 64.3299 132.572 64.3344C132.572 64.3388 132.572 64.3433 132.572 64.3477C132.572 64.3522 132.572 64.3566 132.572 64.3611C132.572 64.3655 132.572 64.37 132.572 64.3744C132.572 64.3789 132.572 64.3833 132.572 64.3877C132.572 64.3922 132.572 64.3966 132.572 64.4011C132.572 64.4055 132.572 64.41 132.572 64.4144C132.572 64.4188 132.572 64.4233 132.572 64.4277C132.572 64.4321 132.572 64.4366 132.572 64.441C132.572 64.4454 132.572 64.4499 132.572 64.4543C132.572 64.4587 132.572 64.4632 132.572 64.4676C132.572 64.472 132.572 64.4765 132.572 64.4809C132.572 64.4853 132.572 64.4897 132.572 64.4942C132.572 64.4986 132.572 64.503 132.572 64.5074C132.572 64.5118 132.572 64.5163 132.572 64.5207C132.572 64.5251 132.572 64.5295 132.572 64.5339C132.572 64.5384 132.572 64.5428 132.572 64.5472C132.572 64.5516 132.572 64.556 132.572 64.5604C132.572 64.5648 132.572 64.5692 132.572 64.5737C132.572 64.5781 132.572 64.5825 132.572 64.5869C132.572 64.5913 132.572 64.5957 132.572 64.6001C132.572 64.6045 132.572 64.6089 132.572 64.6133C132.572 64.6177 132.572 64.6221 132.572 64.6265C132.572 64.6309 132.572 64.6353 132.572 64.6397C132.572 64.6441 132.572 64.6485 132.572 64.6529C132.572 64.6573 132.572 64.6617 132.572 64.6661C132.572 64.6705 132.572 64.6749 132.572 64.6792C132.572 64.6836 132.572 64.688 132.572 64.6924C132.572 64.6968 132.572 64.7012 132.572 64.7056C132.572 64.71 132.572 64.7143 132.572 64.7187C132.572 64.7231 132.572 64.7275 132.572 64.7319C132.572 64.7362 132.572 64.7406 132.572 64.745C132.572 64.7494 132.572 64.7538 132.572 64.7581C132.572 64.7625 132.572 64.7669 132.572 64.7713C132.572 64.7756 132.572 64.78 132.572 64.7844C132.572 64.7887 132.572 64.7931 132.572 64.7975C132.572 64.8018 132.572 64.8062 132.572 64.8106C132.572 64.8149 132.572 64.8193 132.572 64.8237C132.572 64.828 132.572 64.8324 132.572 64.8367C132.572 64.8411 132.572 64.8455 132.572 64.8498C132.572 64.8542 132.572 64.8585 132.572 64.8629C132.572 64.8673 132.572 64.8716 132.572 64.876C132.572 64.8803 132.572 64.8847 132.572 64.889C132.572 64.8934 132.572 64.8977 132.572 64.9021C132.572 64.9064 132.572 64.9108 132.572 64.9151C132.572 64.9194 132.572 64.9238 132.572 64.9281C132.572 64.9325 132.572 64.9368 132.572 64.9412C132.572 64.9455 132.572 64.9498 132.572 64.9542C132.572 64.9585 132.572 64.9629 132.572 64.9672C132.572 64.9715 132.572 64.9759 132.572 64.9802C132.572 64.9845 132.572 64.9889 132.572 64.9932C132.572 64.9975 132.572 65.0019 132.572 65.0062C132.572 65.0105 132.572 65.0148 132.572 65.0192C132.572 65.0235 132.572 65.0278 132.572 65.0321C132.572 65.0365 132.572 65.0408 132.572 65.0451C132.572 65.0494 132.572 65.0537 132.572 65.0581C132.572 65.0624 132.572 65.0667 132.572 65.071C132.572 65.0753 132.572 65.0796 132.572 65.084C132.572 65.0883 132.572 65.0926 132.572 65.0969C132.572 65.1012 132.572 65.1055 132.572 65.1098C132.572 65.1141 132.572 65.1184 132.572 65.1228C132.572 65.1271 132.572 65.1314 132.572 65.1357C132.572 65.14 132.572 65.1443 132.572 65.1486C132.572 65.1529 132.572 65.1572 132.572 65.1615C132.572 65.1658 132.572 65.1701 132.572 65.1744C132.572 65.1787 132.572 65.183 132.572 65.1873C132.572 65.1916 132.572 65.1958 132.572 65.2001C132.572 65.2044 132.572 65.2087 132.572 65.213C132.572 65.2173 132.572 65.2216 132.572 65.2259C132.572 65.2302 132.572 65.2344 132.572 65.2387C132.572 65.243 132.572 65.2473 132.572 65.2516C132.572 65.2559 132.572 65.2601 132.572 65.2644C132.572 65.2687 132.572 65.273 132.572 65.2773C132.572 65.2815 132.572 65.2858 132.572 65.2901C132.572 65.2944 132.572 65.2986 132.572 65.3029C132.572 65.3072 132.572 65.3114 132.572 65.3157C132.572 65.32 132.572 65.3243 132.572 65.3285C132.572 65.3328 132.572 65.3371 132.572 65.3413C132.572 65.3456 132.572 65.3498 132.572 65.3541C132.572 65.3584 132.572 65.3626 132.572 65.3669C132.572 65.3712 132.572 65.3754 132.572 65.3797C132.572 65.3839 132.572 65.3882 132.572 65.3924C132.572 65.3967 132.572 65.4009 132.572 65.4052C132.572 65.4095 132.572 65.4137 132.572 65.4179C132.572 65.4222 132.572 65.4264 132.572 65.4307C132.572 65.4349 132.572 65.4392 132.572 65.4434C132.572 65.4477 132.572 65.4519 132.572 65.4562C132.572 65.4604 132.572 65.4647 132.572 65.4689C132.572 65.4731 132.572 65.4774 132.572 65.4816C132.572 65.4858 132.572 65.4901 132.572 65.4943C132.572 65.4986 132.572 65.5028 132.572 65.507C132.572 65.5113 132.572 65.5155 132.572 65.5197C132.572 65.5239 132.572 65.5282 132.572 65.5324C132.572 65.5366 132.572 65.5409 132.572 65.5451C132.572 65.5493 132.572 65.5535 132.572 65.5578C132.572 65.562 132.572 65.5662 132.572 65.5704C132.572 65.5746 132.572 65.5789 132.572 65.5831C132.572 65.5873 132.572 65.5915 132.572 65.5957C132.572 65.5999 132.572 65.6042 132.572 65.6084C132.572 65.6126 132.572 65.6168 132.572 65.621C132.572 65.6252 132.572 65.6294 132.572 65.6336C132.572 65.6379 132.572 65.6421 132.572 65.6463C132.572 65.6505 132.572 65.6547 132.572 65.6589C132.572 65.6631 132.572 65.6673 132.572 65.6715C132.572 65.6757 132.572 65.6799 132.572 65.6841C132.572 65.6883 132.572 65.6925 132.572 65.6967C132.572 65.7009 132.572 65.7051 132.572 65.7093C132.572 65.7135 132.572 65.7176 132.572 65.7218C132.572 65.726 132.572 65.7302 132.572 65.7344C132.572 65.7386 132.572 65.7428 132.572 65.747C132.572 65.7512 132.572 65.7553 132.572 65.7595C132.572 65.7637 132.572 65.7679 132.572 65.7721C132.572 65.7763 132.572 65.7804 132.572 65.7846C132.572 65.7888 132.572 65.793 132.572 65.7971C132.572 65.8013 132.572 65.8055 132.572 65.8097C132.572 65.8139 132.572 65.818 132.572 65.8222C132.572 65.8264 132.572 65.8305 132.572 65.8347C132.572 65.8389 132.572 65.843 132.572 65.8472C132.572 65.8514 132.572 65.8555 132.572 65.8597C132.572 65.8639 132.572 65.868 132.572 65.8722C132.572 65.8764 132.572 65.8805 132.572 65.8847C132.572 65.8888 132.572 65.893 132.572 65.8972C132.572 65.9013 132.572 65.9055 132.572 65.9096C132.572 65.9138 132.572 65.9179 132.572 65.9221C132.572 65.9262 132.572 65.9304 132.572 65.9345C132.572 65.9387 132.572 65.9428 132.572 65.947C132.572 65.9511 132.572 65.9553 132.572 65.9594C132.572 65.9636 132.572 65.9677 132.572 65.9718C132.572 65.976 132.572 65.9801 132.572 65.9843C132.572 65.9884 132.572 65.9925 132.572 65.9967C132.572 66.0008 132.572 66.005 132.572 66.0091C132.572 66.0132 132.572 66.0174 132.572 66.0215C132.572 66.0256 132.572 66.0298 132.572 66.0339C132.572 66.038 132.572 66.0421 132.572 66.0463C132.572 66.0504 132.572 66.0545 132.572 66.0587C132.572 66.0628 132.572 66.0669 132.572 66.071C132.572 66.0751 132.572 66.0793 132.572 66.0834C132.572 66.0875 132.572 66.0916 132.572 66.0957C132.572 66.0999 132.572 66.104 132.572 66.1081C132.572 66.1122 132.572 66.1163 132.572 66.1204C132.572 66.1245 132.572 66.1287 132.572 66.1328C132.572 66.1369 132.572 66.141 132.572 66.1451C132.572 66.1492 132.572 66.1533 132.572 66.1574C132.572 66.1615 132.572 66.1656 132.572 66.1697C132.572 66.1738 132.572 66.1779 132.572 66.182C132.572 66.1861 132.572 66.1902 132.572 66.1943C132.572 66.1984 132.572 66.2025 132.572 66.2066C132.572 66.2107 132.572 66.2148 132.572 66.2189C132.572 66.223 132.572 66.2271 132.572 66.2312C132.572 66.2353 132.572 66.2394 132.572 66.2435C132.572 66.2475 132.572 66.2516 132.572 66.2557C132.572 66.2598 132.572 66.2639 132.572 66.268C132.572 66.2721 132.572 66.2761 132.572 66.2802C132.572 66.2843 132.572 66.2884 132.572 66.2925C132.572 66.2965 132.572 66.3006 132.572 66.3047C132.572 66.3088 132.572 66.3128 132.572 66.3169C132.572 66.321 132.572 66.3251 132.572 66.3291C132.572 66.3332 132.572 66.3373 132.572 66.3413C132.572 66.3454 132.572 66.3495 132.572 66.3535C132.572 66.3576 132.572 66.3617 132.572 66.3657C132.572 66.3698 132.572 66.3739 132.572 66.3779C132.572 66.382 132.572 66.3861 132.572 66.3901C132.572 66.3942 132.572 66.3982 132.572 66.4023C132.572 66.4063 132.572 66.4104 132.572 66.4144C132.572 66.4185 132.572 66.4226 132.572 66.4266C132.572 66.4307 132.572 66.4347 132.572 66.4388C132.572 66.4428 132.572 66.4469 132.572 66.4509C132.572 66.4549 132.572 66.459 132.572 66.463C132.572 66.4671 132.572 66.4711 132.572 66.4752C132.572 66.4792 132.572 66.4832 132.572 66.4873C132.572 66.4913 132.572 66.4954 132.572 66.4994C132.572 66.5034 132.572 66.5075 132.572 66.5115C132.572 66.5155 132.572 66.5196 132.572 66.5236C132.572 66.5276 132.572 66.5317 132.572 66.5357C132.572 66.5397 132.572 66.5438 132.572 66.5478C132.572 66.5518 132.572 66.5558 132.572 66.5599C132.572 66.5639 132.572 66.5679 132.572 66.5719C132.572 66.576 132.572 66.58 132.572 66.584C132.572 66.588 132.572 66.592 132.572 66.5961C132.572 66.6001 132.572 66.6041 132.572 66.6081C132.572 66.6121 132.572 66.6161 132.572 66.6201C132.572 66.6242 132.572 66.6282 132.572 66.6322C132.572 66.6362 132.572 66.6402 132.572 66.6442C132.572 66.6482 132.572 66.6522 132.572 66.6562C132.572 66.6602 132.572 66.6642 132.572 66.6682C132.572 66.6722 132.572 66.6762 132.572 66.6802C132.572 66.6842 132.572 66.6882 132.572 66.6922C132.572 66.6962 132.572 66.7002 132.572 66.7042C132.572 66.7082 132.572 66.7122 132.572 66.7162C132.572 66.7202 132.572 66.7242 132.572 66.7282C132.572 66.7322 132.572 66.7362 132.572 66.7401C132.572 66.7441 132.572 66.7481 132.572 66.7521C132.572 66.7561 132.572 66.7601 132.572 66.7641C132.572 66.768 132.572 66.772 132.572 66.776C132.572 66.78 132.572 66.784 132.572 66.7879C132.572 66.7919 132.572 66.7959 132.572 66.7999C132.572 66.8038 132.572 66.8078 132.572 66.8118C132.572 66.8158 132.572 66.8197 132.572 66.8237C132.572 66.8277 132.572 66.8317 132.572 66.8356C132.572 66.8396 132.572 66.8436 132.572 66.8475C132.572 66.8515 132.572 66.8555 132.572 66.8594C132.572 66.8634 132.572 66.8673 132.572 66.8713C132.572 66.8753 132.572 66.8792 132.572 66.8832C132.572 66.8871 132.572 66.8911 132.572 66.8951C132.572 66.899 132.572 66.903 132.572 66.9069C132.572 66.9109 132.572 66.9148 132.572 66.9188C132.572 66.9227 132.572 66.9267 132.572 66.9306C132.572 66.9346 132.572 66.9385 132.572 66.9425C132.572 66.9464 132.572 66.9504 132.572 66.9543C132.572 66.9582 132.572 66.9622 132.572 66.9661C132.572 66.9701 132.572 66.974 132.572 66.978C132.572 66.9819 132.572 66.9858 132.572 66.9898C132.572 66.9937 132.572 66.9976 132.572 67.0016C132.572 67.0055 132.572 67.0094 132.572 67.0134C132.572 67.0173 132.572 67.0212 132.572 67.0252C132.572 67.0291 132.572 67.033 132.572 67.0369C132.572 67.0409 132.572 67.0448 132.572 67.0487C132.572 67.0526 132.572 67.0566 132.572 67.0605C132.572 67.0644 132.572 67.0683 132.572 67.0723C132.572 67.0762 132.572 67.0801 132.572 67.084C132.572 67.0879 132.572 67.0918 132.572 67.0957C132.572 67.0997 132.572 67.1036 132.572 67.1075C132.572 67.1114 132.572 67.1153 132.572 67.1192C132.572 67.1231 132.572 67.127 132.572 67.1309C132.572 67.1349 132.572 67.1388 132.572 67.1427C132.572 67.1466 132.572 67.1505 132.572 67.1544C132.572 67.1583 132.572 67.1622 132.572 67.1661C132.572 67.17 132.572 67.1739 132.572 67.1778C132.572 67.1817 132.572 67.1856 132.572 67.1895C132.572 67.1934 132.572 67.1973 132.572 67.2011C132.572 67.205 132.572 67.2089 132.572 67.2128C132.572 67.2167 132.572 67.2206 132.572 67.2245C132.572 67.2284 132.572 67.2323 132.572 67.2361C132.572 67.24 132.572 67.2439 132.572 67.2478C132.572 67.2517 132.572 67.2556 132.572 67.2594C132.572 67.2633 132.572 67.2672 132.572 67.2711C132.572 67.2749 132.572 67.2788 132.572 67.2827C132.572 67.2866 132.572 67.2905 132.572 67.2943C132.572 67.2982 132.572 67.3021 132.572 67.3059C132.572 67.3098 132.572 67.3137 132.572 67.3175C132.572 67.3214 132.572 67.3253 132.572 67.3291C132.572 67.333 132.572 67.3369 132.572 67.3407C132.572 67.3446 132.572 67.3485 132.572 67.3523C132.572 67.3562 132.572 67.36 132.572 67.3639C132.572 67.3678 132.572 67.3716 132.572 67.3755C132.572 67.3793 132.572 67.3832 132.572 67.387C132.572 67.3909 132.572 67.3947 132.572 67.3986C132.572 67.4024 132.572 67.4063 132.572 67.4101C132.572 67.414 132.572 67.4178 132.572 67.4217C132.572 67.4255 132.572 67.4294 132.572 67.4332C132.572 67.4371 132.572 67.4409 132.572 67.4447C132.572 67.4486 132.572 67.4524 132.572 67.4563C132.572 67.4601 132.572 67.4639 132.572 67.4678C132.572 67.4716 132.572 67.4754 132.572 67.4793C132.572 67.4831 132.572 67.4869 132.572 67.4908C132.572 67.4946 132.572 67.4984 132.572 67.5023C132.572 67.5061 132.572 67.5099 132.572 67.5137C132.572 67.5176 132.572 67.5214 132.572 67.5252C132.572 67.529 132.572 67.5329 132.572 67.5367C132.572 67.5405 132.572 67.5443 132.572 67.5481C132.572 67.552 132.572 67.5558 132.572 67.5596C132.572 67.5634 132.572 67.5672 132.572 67.571C132.572 67.5749 132.572 67.5787 132.572 67.5825C132.572 67.5863 132.572 67.5901 132.572 67.5939C132.572 67.5977 132.572 67.6015 132.572 67.6053C132.572 67.6091 132.572 67.6129 132.572 67.6168C132.572 67.6206 132.572 67.6244 132.572 67.6282C132.572 67.632 132.572 67.6358 132.572 67.6396C132.572 67.6434 132.572 67.6472 132.572 67.651C132.572 67.6548 132.572 67.6585 132.572 67.6623C132.572 67.6661 132.572 67.6699 132.572 67.6737C132.572 67.6775 132.572 67.6813 132.572 67.6851C132.572 67.6889 132.572 67.6927 132.572 67.6965C132.572 67.7002 132.572 67.704 132.572 67.7078C132.572 67.7116 132.572 67.7154 132.572 67.7192C132.572 67.7229 132.572 67.7267 132.572 67.7305C132.572 67.7343 132.572 67.7381 132.572 67.7418C132.572 67.7456 132.572 67.7494 132.572 67.7532C132.572 67.7569 132.572 67.7607 132.572 67.7645C132.572 67.7683 132.572 67.772 132.572 67.7758C132.572 67.7796 132.572 67.7833 132.572 67.7871C132.572 67.7909 132.572 67.7946 132.572 67.7984C132.572 67.8022 132.572 67.8059 132.572 67.8097C132.572 67.8135 132.572 67.8172 132.572 67.821C132.572 67.8247 132.572 67.8285 132.572 67.8323C132.572 67.836 132.572 67.8398 132.572 67.8435C132.572 67.8473 132.572 67.851 132.572 67.8548C132.572 67.8585 132.572 67.8623 132.572 67.866C132.572 67.8698 132.572 67.8735 132.572 67.8773C132.572 67.881 132.572 67.8848 132.572 67.8885C132.572 67.8923 132.572 67.896 132.572 67.8998C132.572 67.9035 132.572 67.9072 132.572 67.911C132.572 67.9147 132.572 67.9185 132.572 67.9222C132.572 67.9259 132.572 67.9297 132.572 67.9334C132.572 67.9372 132.572 67.9409 132.572 67.9446C132.572 67.9484 132.572 67.9521 132.572 67.9558C132.572 67.9595 132.572 67.9633 132.572 67.967C132.572 67.9707 132.572 67.9745 132.572 67.9782C132.572 67.9819 132.572 67.9856 132.572 67.9894C132.572 67.9931 132.572 67.9968 132.572 68.0005C132.572 68.0042 132.572 68.008 132.572 68.0117C132.572 68.0154 132.572 68.0191 132.572 68.0228C132.572 68.0266 132.572 68.0303 132.572 68.034C132.572 68.0377 132.572 68.0414 132.572 68.0451C132.572 68.0488 132.572 68.0525 132.572 68.0562C132.572 68.06 132.572 68.0637 132.572 68.0674C132.572 68.0711 132.572 68.0748 132.572 68.0785C132.572 68.0822 132.572 68.0859 132.572 68.0896C132.572 68.0933 132.572 68.097 132.572 68.1007C132.572 68.1044 132.572 68.1081 132.572 68.1118C132.572 68.1155 132.572 68.1192 132.572 68.1229C132.572 68.1266 132.572 68.1303 132.572 68.1339C132.572 68.1376 132.572 68.1413 132.572 68.145C132.572 68.1487 132.572 68.1524 132.572 68.1561C132.572 68.1598 132.572 68.1635 132.572 68.1671C132.572 68.1708 132.572 68.1745 132.572 68.1782C132.572 68.1819 132.572 68.1855 132.572 68.1892C132.572 68.1929 132.572 68.1966 132.572 68.2003C132.572 68.2039 132.572 68.2076 132.572 68.2113C132.572 68.215 132.572 68.2186 132.572 68.2223C132.572 68.226 132.572 68.2296 132.572 68.2333C132.572 68.237 132.572 68.2407 132.572 68.2443C132.572 68.248 132.572 68.2517 132.572 68.2553C132.572 68.259 132.572 68.2626 132.572 68.2663C132.572 68.27 132.572 68.2736 132.572 68.2773C132.572 68.2809 132.572 68.2846 132.572 68.2883C132.572 68.2919 132.572 68.2956 132.572 68.2992C132.572 68.3029 132.572 68.3065 132.572 68.3102C132.572 68.3138 132.572 68.3175 132.572 68.3211C132.572 68.3248 132.572 68.3284 132.572 68.3321C132.572 68.3357 132.572 68.3394 132.572 68.343C132.572 68.3467 132.572 68.3503 132.572 68.354C132.572 68.3576 132.572 68.3612 132.572 68.3649C132.572 68.3685 132.572 68.3722 132.572 68.3758C132.572 68.3794 132.572 68.3831 132.572 68.3867C132.572 68.3903 132.572 68.394 132.572 68.3976C132.572 68.4012 132.572 68.4049 132.572 68.4085C132.572 68.4121 132.572 68.4158 132.572 68.4194C132.572 68.423 132.572 68.4266 132.572 68.4303C132.572 68.4339 132.572 68.4375 132.572 68.4411C132.572 68.4448 132.572 68.4484 132.572 68.452C132.572 68.4556 132.572 68.4592 132.572 68.4629C132.572 68.4665 132.572 68.4701 132.572 68.4737C132.572 68.4773 132.572 68.4809 132.572 68.4846C132.572 68.4882 132.572 68.4918 132.572 68.4954C132.572 68.499 132.572 68.5026 132.572 68.5062C132.572 68.5098 132.572 68.5134 132.572 68.517C132.572 68.5206 132.572 68.5243 132.572 68.5279C132.572 68.5315 132.572 68.5351 132.572 68.5387C132.572 68.5423 132.572 68.5459 132.572 68.5495C132.572 68.5531 132.572 68.5567 132.572 68.5603C132.572 68.5638 132.572 68.5674 132.572 68.571C132.572 68.5746 132.572 68.5782 132.572 68.5818C132.572 68.5854 132.572 68.589 132.572 68.5926C132.572 68.5962 132.572 68.5998 132.572 68.6033C132.572 68.6069 132.572 68.6105 132.572 68.6141C132.572 68.6177 132.572 68.6213 132.572 68.6248C132.572 68.6284 132.572 68.632 132.572 68.6356C132.572 68.6392 132.572 68.6427 132.572 68.6463C132.572 68.6499 132.572 68.6535 132.572 68.657C132.572 68.6606 132.572 68.6642 132.572 68.6678C132.572 68.6713 132.572 68.6749 132.572 68.6785C132.572 68.682 132.572 68.6856 132.572 68.6892C132.572 68.6927 132.572 68.6963 132.572 68.6999C132.572 68.7034 132.572 68.707 132.572 68.7106C132.572 68.7141 132.572 68.7177 132.572 68.7212C132.572 68.7248 132.572 68.7284 132.572 68.7319C132.572 68.7355 132.572 68.739 132.572 68.7426C132.572 68.7461 132.572 68.7497 132.572 68.7532C132.572 68.7568 132.572 68.7603 132.572 68.7639C132.572 68.7674 132.572 68.771 132.572 68.7745C132.572 68.7781 132.572 68.7816 132.572 68.7852C132.572 68.7887 132.572 68.7923 132.572 68.7958C132.572 68.7993 132.572 68.8029 132.572 68.8064C132.572 68.81 132.572 68.8135 132.572 68.817C132.572 68.8206 132.572 68.8241 132.572 68.8276C132.572 68.8312 132.572 68.8347 132.572 68.8382C132.572 68.8418 132.572 68.8453 132.572 68.8488C132.572 68.8524 132.572 68.8559 132.572 68.8594C132.572 68.8629 132.572 68.8665 132.572 68.87C132.572 68.8735 132.572 68.877 132.572 68.8806C132.572 68.8841 132.572 68.8876 132.572 68.8911C132.572 68.8947 132.572 68.8982 132.572 68.9017C132.572 68.9052 132.572 68.9087 132.572 68.9122C132.572 68.9158 132.572 68.9193 132.572 68.9228C132.572 68.9263 132.572 68.9298 132.572 68.9333C132.572 68.9368 132.572 68.9403 132.572 68.9438C132.572 68.9473 132.572 68.9509 132.572 68.9544C132.572 68.9579 132.572 68.9614 132.572 68.9649C132.572 68.9684 132.572 68.9719 132.572 68.9754C132.572 68.9789 132.572 68.9824 132.572 68.9859C132.572 68.9894 132.572 68.9929 132.572 68.9964C132.572 68.9999 132.572 69.0034 132.572 69.0068C132.572 69.0103 132.572 69.0138 132.572 69.0173C132.572 69.0208 132.572 69.0243 132.572 69.0278C132.572 69.0313 132.572 69.0348 132.572 69.0382C132.572 69.0417 132.572 69.0452 132.572 69.0487C132.572 69.0522 132.572 69.0557 132.572 69.0592C132.572 69.0626 132.572 69.0661 132.572 69.0696C132.572 69.0731 132.572 69.0765 132.572 69.08C132.572 69.0835 132.572 69.087 132.572 69.0904C132.572 69.0939 132.572 69.0974 132.572 69.1009C132.572 69.1043 132.572 69.1078 132.572 69.1113C132.572 69.1147 132.572 69.1182 132.572 69.1217C132.572 69.1251 132.572 69.1286 132.572 69.1321C132.572 69.1355 132.572 69.139 132.572 69.1425C132.572 69.1459 132.572 69.1494 132.572 69.1528C132.572 69.1563 132.572 69.1597 132.572 69.1632C132.572 69.1667 132.572 69.1701 132.572 69.1736C132.572 69.177 132.572 69.1805 132.572 69.1839C132.572 69.1874 132.572 69.1908 132.572 69.1943C132.572 69.1977 132.572 69.2012 132.572 69.2046C132.572 69.2081 132.572 69.2115 132.572 69.215C132.572 69.2184 132.572 69.2218 132.572 69.2253C132.572 69.2287 132.572 69.2322 132.572 69.2356C132.572 69.239 132.572 69.2425 132.572 69.2459C132.572 69.2494 132.572 69.2528 132.572 69.2562C132.572 69.2597 132.572 69.2631 132.572 69.2665C132.572 69.27 132.572 69.2734 132.572 69.2768C132.572 69.2802 132.572 69.2837 132.572 69.2871C132.572 69.2905 132.572 69.2939 132.572 69.2974C132.572 69.3008 132.572 69.3042 132.572 69.3076C132.572 69.3111 132.572 69.3145 132.572 69.3179C132.572 69.3213 132.572 69.3247 132.572 69.3282C132.572 69.3316 132.572 69.335 132.572 69.3384C132.572 69.3418 132.572 69.3452 132.572 69.3486C132.572 69.3521 132.572 69.3555 132.572 69.3589C132.572 69.3623 132.572 69.3657 132.572 69.3691C132.572 69.3725 132.572 69.3759 132.572 69.3793C132.572 69.3827 132.572 69.3861 132.572 69.3895C132.572 69.3929 132.572 69.3963 132.572 69.3997C132.572 69.4031 132.572 69.4065 132.572 69.4099C132.572 69.4133 132.572 69.4167 132.572 69.4201C132.572 69.4235 132.572 69.4269 132.572 69.4303C132.572 69.4337 132.572 69.4371 132.572 69.4405C132.572 69.4439 132.572 69.4473 132.572 69.4506C132.572 69.454 132.572 69.4574 132.572 69.4608C132.572 69.4642 132.572 69.4676 132.572 69.471C132.572 69.4743 132.572 69.4777 132.572 69.4811C132.572 69.4845 132.572 69.4879 132.572 69.4912C132.572 69.4946 132.572 69.498 132.572 69.5014C132.572 69.5047 132.572 69.5081 132.572 69.5115C132.572 69.5149 132.572 69.5182 132.572 69.5216C132.572 69.525 132.572 69.5283 132.572 69.5317C132.572 69.5351 132.572 69.5384 132.572 69.5418C132.572 69.5452 132.572 69.5485 132.572 69.5519C132.572 69.5553 132.572 69.5586 132.572 69.562C132.572 69.5653 132.572 69.5687 132.572 69.5721C132.572 69.5754 132.572 69.5788 132.572 69.5821C132.572 69.5855 132.572 69.5888 132.572 69.5922C132.572 69.5956 132.572 69.5989 132.572 69.6023C132.572 69.6056 132.572 69.609 132.572 69.6123C132.572 69.6157 132.572 69.619 132.572 69.6223C132.572 69.6257 132.572 69.629 132.572 69.6324C132.572 69.6357 132.572 69.6391 132.572 69.6424C132.572 69.6458 132.572 69.6491 132.572 69.6524C132.572 69.6558 132.572 69.6591 132.572 69.6624C132.572 69.6658 132.572 69.6691 132.572 69.6724C132.572 69.6758 132.572 69.6791 132.572 69.6824C132.572 69.6858 132.572 69.6891 132.572 69.6924C132.572 69.6958 132.572 69.6991 132.572 69.7024C132.572 69.7057 132.572 69.7091 132.572 69.7124C132.572 69.7157 132.572 69.719 132.572 69.7224C132.572 69.7257 132.572 69.729 132.572 69.7323C132.572 69.7356 132.572 69.739 132.572 69.7423C132.572 69.7456 132.572 69.7489 132.572 69.7522C132.572 69.7555 132.572 69.7588 132.572 69.7622C132.572 69.7655 132.572 69.7688 132.572 69.7721C132.572 69.7754 132.572 69.7787 132.572 69.782C132.572 69.7853 132.572 69.7886 132.572 69.7919C132.572 69.7952 132.572 69.7985 132.572 69.8018C132.572 69.8051 132.572 69.8084 132.572 69.8117C132.572 69.815 132.572 69.8183 132.572 69.8216C132.572 69.8249 132.572 69.8282 132.572 69.8315C132.572 69.8348 132.572 69.8381 132.572 69.8414C132.572 69.8447 132.572 69.848 132.572 69.8513C132.572 69.8546 132.572 69.8579 132.572 69.8611C132.572 69.8644 132.572 69.8677 132.572 69.871C132.572 69.8743 132.572 69.8776 132.572 69.8808C132.572 69.8841 132.572 69.8874 132.572 69.8907C132.572 69.894 132.572 69.8973 132.572 69.9005C132.572 69.9038 132.572 69.9071 132.572 69.9104C132.572 69.9136 132.572 69.9169 132.572 69.9202C132.572 69.9235 132.572 69.9267 132.572 69.93C132.572 69.9333 132.572 69.9365 132.572 69.9398C132.572 69.9431 132.572 69.9463 132.572 69.9496C132.572 69.9529 132.572 69.9561 132.572 69.9594C132.572 69.9627 132.572 69.9659 132.572 69.9692C132.572 69.9724 132.572 69.9757 132.572 69.979C132.572 69.9822 132.572 69.9855 132.572 69.9887C132.572 69.992 132.572 69.9952 132.572 69.9985C132.572 70.0017 132.572 70.005 132.572 70.0082C132.572 70.0115 132.572 70.0147 132.572 70.018C132.572 70.0212 132.572 70.0245 132.572 70.0277C132.572 70.031 132.572 70.0342 132.572 70.0375C132.572 70.0407 132.572 70.0439 132.572 70.0472C132.572 70.0504 132.572 70.0537 132.572 70.0569C132.572 70.0601 132.572 70.0634 132.572 70.0666C132.572 70.0698 132.572 70.0731 132.572 70.0763C132.572 70.0795 132.572 70.0828 132.572 70.086C132.572 70.0892 132.572 70.0925 132.572 70.0957C132.572 70.0989 132.572 70.1022 132.572 70.1054H134.322ZM134.322 64.2206C134.413 61.8568 134.595 59.4462 134.868 56.9888L133.128 56.7955C132.851 59.293 132.666 61.7457 132.573 64.1533L134.322 64.2206ZM134.868 56.9888C135.138 54.5551 135.589 52.1672 136.219 49.8248L134.529 49.3698C133.875 51.7989 133.408 54.2742 133.128 56.7955L134.868 56.9888ZM136.221 49.8169C136.847 47.4033 137.692 45.2751 138.749 43.4248L137.23 42.5566C136.085 44.5602 135.186 46.8364 134.527 49.3777L136.221 49.8169ZM138.733 43.4513C139.867 41.6203 141.252 40.1523 142.888 39.0332L141.9 37.5888C140.049 38.8555 138.498 40.5072 137.245 42.5301L138.733 43.4513ZM142.871 39.0447C144.536 37.9623 146.61 37.3968 149.138 37.3968V35.6467C146.345 35.6467 143.922 36.274 141.917 37.5774L142.871 39.0447ZM149.138 37.3968C151.667 37.3968 153.74 37.9623 155.405 39.0447L156.359 37.5774C154.354 36.274 151.932 35.6467 149.138 35.6467V37.3968ZM155.405 39.0447C157.129 40.1648 158.553 41.63 159.68 43.4513L161.168 42.5301C159.91 40.4976 158.306 38.843 156.359 37.5774L155.405 39.0447ZM159.68 43.4513C160.816 45.2854 161.654 47.3941 162.185 49.7871L163.894 49.4075C163.324 46.8456 162.419 44.5499 161.168 42.5301L159.68 43.4513ZM162.195 49.8248C162.825 52.1672 163.276 54.5551 163.546 56.9888L165.286 56.7955C165.005 54.2742 164.538 51.7989 163.884 49.3698L162.195 49.8248ZM163.55 57.0204C163.911 59.4575 164.091 61.8462 164.091 64.187H165.841C165.841 61.7562 165.654 59.2818 165.281 56.7639L163.55 57.0204ZM164.092 64.2219C164.184 66.5084 164.229 68.4689 164.229 70.1054H165.979C165.979 68.4386 165.933 66.4535 165.841 64.152L164.092 64.2219ZM164.229 70.1054C164.229 72.8402 164.138 76.1749 163.955 80.1123L165.703 80.1936C165.887 76.2397 165.979 72.8761 165.979 70.1054H164.229ZM163.955 80.1113C163.774 83.9017 163.188 87.5999 162.196 91.2072L163.883 91.6713C164.91 87.9379 165.516 84.1119 165.703 80.1946L163.955 80.1113ZM162.192 91.2219C161.305 94.6828 159.803 97.6332 157.695 100.092L159.024 101.23C161.321 98.5503 162.939 95.3529 163.887 91.6566L162.192 91.2219ZM157.684 100.106C155.775 102.429 152.975 103.64 149.138 103.64V105.39C153.375 105.39 156.724 104.031 159.036 101.216L157.684 100.106ZM149.138 103.64C145.4 103.64 142.643 102.434 140.73 100.106L139.378 101.216C141.686 104.026 144.985 105.39 149.138 105.39V103.64ZM140.73 100.106C138.705 97.6402 137.197 94.6778 136.216 91.2017L134.532 91.6768C135.57 95.3579 137.182 98.5433 139.378 101.216L140.73 100.106ZM136.223 91.227C135.32 87.6137 134.778 83.9088 134.597 80.1113L132.849 80.1946C133.035 84.1049 133.594 87.9241 134.525 91.6515L136.223 91.227ZM134.597 80.1123C134.414 76.1749 134.322 72.8402 134.322 70.1054H132.572C132.572 72.8761 132.665 76.2397 132.849 80.1936L134.597 80.1123ZM113.028 70.1054C113.028 79.7893 113.949 87.9499 115.813 94.5669L117.498 94.0924C115.691 87.6797 114.778 79.6907 114.778 70.1054H113.028ZM115.817 94.5811C117.767 101.081 120.383 106.336 123.691 110.305L125.035 109.185C121.92 105.447 119.397 100.424 117.494 94.0782L115.817 94.5811ZM123.691 110.305C126.987 114.26 130.821 117.107 135.193 118.818L135.831 117.189C131.762 115.596 128.163 112.938 125.035 109.185L123.691 110.305ZM135.199 118.821C139.615 120.512 144.263 121.356 149.138 121.356V119.606C144.47 119.606 140.034 118.798 135.825 117.186L135.199 118.821ZM149.138 121.356C154.102 121.356 158.753 120.512 163.083 118.818L162.445 117.189C158.333 118.798 153.9 119.606 149.138 119.606V121.356ZM163.077 118.821C167.542 117.111 171.424 114.264 174.723 110.305L173.378 109.185C170.254 112.934 166.612 115.593 162.451 117.186L163.077 118.821ZM174.715 110.315C178.122 106.34 180.74 101.078 182.6 94.57L180.917 94.0893C179.106 100.428 176.586 105.443 173.386 109.176L174.715 110.315ZM182.597 94.5778C184.556 87.9566 185.524 79.792 185.524 70.1054H183.774C183.774 79.6881 182.815 87.673 180.919 94.0815L182.597 94.5778ZM185.524 70.1054C185.524 60.6924 184.555 52.7548 182.595 46.3145L180.921 46.8241C182.815 53.0465 183.774 60.7996 183.774 70.1054H185.524ZM182.6 46.3289C180.74 39.8212 178.122 34.5591 174.715 30.5844L173.386 31.7233C176.586 35.4563 179.106 40.4712 180.917 46.8097L182.6 46.3289ZM174.723 30.5937C171.424 26.635 167.542 23.7882 163.077 22.0784L162.451 23.7127C166.612 25.3063 170.254 27.9649 173.378 31.714L174.723 30.5937ZM163.083 22.0807C158.753 20.3865 154.102 19.5431 149.138 19.5431V21.2931C153.9 21.2931 158.333 22.1014 162.445 23.7104L163.083 22.0807ZM149.138 19.5431C144.263 19.5431 139.615 20.3872 135.199 22.0784L135.825 23.7127C140.034 22.1006 144.47 21.2931 149.138 21.2931V19.5431ZM135.193 22.0807C130.821 23.7917 126.987 26.6388 123.691 30.5937L125.035 31.714C128.163 27.9611 131.762 25.3028 135.831 23.7104L135.193 22.0807ZM123.691 30.5937C120.383 34.5632 117.767 39.8177 115.817 46.3179L117.494 46.8207C119.397 40.4747 121.92 35.4522 125.035 31.714L123.691 30.5937ZM115.815 46.3257C113.95 52.7617 113.028 60.6951 113.028 70.1054H114.778C114.778 60.7969 115.691 53.0396 117.496 46.8129L115.815 46.3257ZM239.232 46.8446V80.2906H240.982V46.8446H239.232ZM240.107 79.4156H214.781V81.1656H240.107V79.4156ZM215.483 80.8133L240.396 47.3673L238.992 46.3219L214.08 79.7679L215.483 80.8133ZM239.694 47.7196H240.107V45.9695H239.694V47.7196ZM239.232 98.1443V118.108H240.982V98.1443H239.232ZM240.69 119.567H258.105V117.817H240.69V119.567ZM259.563 118.108V98.1443H257.813V118.108H259.563ZM258.688 99.0193H270.905V97.2693H258.688V99.0193ZM272.363 97.5609V80.8739H270.613V97.5609H272.363ZM270.905 79.4156H258.688V81.1656H270.905V79.4156ZM259.563 80.2906V22.9284H257.813V80.2906H259.563ZM258.105 21.47H235.667V23.2201H258.105V21.47ZM234.498 22.057L192.946 77.8234L194.35 78.869L235.901 23.1026L234.498 22.057ZM192.657 78.6947V97.5609H194.408V78.6947H192.657ZM194.116 99.0193H240.107V97.2693H194.116V99.0193ZM192.657 97.5609C192.657 98.3664 193.31 99.0193 194.116 99.0193V97.2693C194.277 97.2693 194.408 97.3998 194.408 97.5609H192.657ZM192.946 77.8234C192.759 78.0751 192.657 78.3807 192.657 78.6947H194.408C194.408 78.7575 194.387 78.8186 194.35 78.869L192.946 77.8234ZM235.667 21.47C235.207 21.47 234.773 21.6876 234.498 22.057L235.901 23.1026C235.846 23.1765 235.759 23.2201 235.667 23.2201V21.47ZM259.563 22.9284C259.563 22.1229 258.91 21.47 258.105 21.47V23.2201C257.944 23.2201 257.813 23.0895 257.813 22.9284H259.563ZM26.1854 77.8234C25.9978 78.0751 25.8965 78.3807 25.8965 78.6947H27.6465C27.6465 78.7575 27.6262 78.8186 27.5887 78.869L26.1854 77.8234ZM270.905 99.0193C271.71 99.0193 272.363 98.3664 272.363 97.5609H270.613C270.613 97.3998 270.744 97.2693 270.905 97.2693V99.0193ZM272.363 80.8739C272.363 80.0685 271.71 79.4156 270.905 79.4156V81.1656C270.744 81.1656 270.613 81.035 270.613 80.8739H272.363ZM25.8965 97.5609C25.8965 98.3664 26.5494 99.0193 27.3548 99.0193V97.2693C27.5159 97.2693 27.6465 97.3998 27.6465 97.5609H25.8965ZM92.802 22.9284C92.802 22.1229 92.149 21.47 91.3436 21.47V23.2201C91.1825 23.2201 91.0519 23.0895 91.0519 22.9284H92.802ZM258.105 119.567C258.91 119.567 259.563 118.914 259.563 118.108H257.813C257.813 117.947 257.944 117.817 258.105 117.817V119.567ZM239.232 118.108C239.232 118.914 239.885 119.567 240.69 119.567V117.817C240.851 117.817 240.982 117.947 240.982 118.108H239.232ZM68.9062 21.47C68.4456 21.47 68.012 21.6876 67.7368 22.057L69.1401 23.1026C69.0851 23.1765 68.9984 23.2201 68.9062 23.2201V21.47ZM105.602 80.8739C105.602 80.0685 104.949 79.4156 104.144 79.4156V81.1656C103.983 81.1656 103.852 81.035 103.852 80.8739H105.602ZM104.144 99.0193C104.949 99.0193 105.602 98.3664 105.602 97.5609H103.852C103.852 97.3998 103.983 97.2693 104.144 97.2693V99.0193ZM91.3436 119.567C92.149 119.567 92.802 118.914 92.802 118.108H91.0519C91.0519 117.947 91.1825 117.817 91.3436 117.817V119.567ZM72.4708 118.108C72.4708 118.914 73.1237 119.567 73.9292 119.567V117.817C74.0903 117.817 74.2209 117.947 74.2209 118.108H72.4708Z" fill="#385DFF" mask="url(#path-7-inside-1_6658_10486)"/>
			</g>
			<path d="M112.002 2.28551C112.229 1.44126 113.284 1.15849 113.902 1.77652L120.391 8.26589C121.009 8.88393 120.727 9.93924 119.882 10.1655L111.018 12.5407C110.174 12.7669 109.401 11.9944 109.627 11.1502L112.002 2.28551Z" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path opacity="0.5" d="M290.388 68.0556C290.603 67.2556 291.603 66.9877 292.188 67.5733L298.338 73.7225C298.923 74.3081 298.655 75.3081 297.855 75.5225L289.455 77.7732C288.655 77.9876 287.923 77.2555 288.138 76.4555L290.388 68.0556Z" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path d="M202.118 127.003C201.904 126.203 200.904 125.936 200.318 126.521L194.169 132.67C193.583 133.256 193.851 134.256 194.651 134.47L203.051 136.721C203.851 136.935 204.583 136.203 204.369 135.403L202.118 127.003Z" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<path opacity="0.5" d="M17.4989 28.5365C17.7251 27.6922 18.7804 27.4095 19.3984 28.0275L25.8878 34.5169C26.5058 35.1349 26.2231 36.1902 25.3788 36.4164L16.5142 38.7917C15.6699 39.0179 14.8974 38.2454 15.1236 37.4011L17.4989 28.5365Z" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<circle cx="268.863" cy="9.33445" r="4.08347" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<circle cx="5.18742" cy="106.171" r="4.08347" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<circle cx="109.024" cy="126.005" r="4.08347" stroke="#385DFF" stroke-width="1.16671" stroke-linecap="round"/>
			<circle class="circle-fill-404" opacity="0.5" cx="39.8969" cy="25.3766" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" opacity="0.5" cx="14.8128" cy="69.1282" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" cx="197.986" cy="112.296" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" opacity="0.5" cx="100.566" cy="58.0444" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" cx="56.8142" cy="125.714" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" opacity="0.5" cx="284.322" cy="102.379" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" cx="206.736" cy="16.6264" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<circle class="circle-fill-404" cx="297.156" cy="53.9609" r="1.16671" fill="#385DFF" stroke="#385DFF" stroke-width="0.583353"/>
			<defs>
			<filter id="filter0_b_6658_10486" x="24.4381" y="18.0847" width="249.384" height="104.73" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
			<feFlood flood-opacity="0" result="BackgroundImageFix"/>
			<feGaussianBlur in="BackgroundImage" stdDeviation="1.16671"/>
			<feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_6658_10486"/>
			<feBlend mode="normal" in="SourceGraphic" in2="effect1_backgroundBlur_6658_10486" result="shape"/>
			</filter>
			</defs>
			</svg>';
			break;
	}

	return $svg_code;

}

/**
 * Custom allowed tags for theme options editor.
 *
 * @since 2.0.0
 *
 * Allows all users to post paragraphs, links, quotes, code, formatting, lists, and images
 *
 * @return array Associative array of allowed tags and attributes
 */
function bb_theme_kses_allowed_tags() {
	return apply_filters(
		'bb_theme_kses_allowed_tags',
		array(

			// Paragraph.
			'p'      => array(
				'class' => array(),
				'id'    => array(),
			),

			// Bold.
			'b'      => array(),

			// Underline.
			'u'      => array(),

			// Italic.
			'i'      => array(),

			// Br.
			'br'     => array(),

			// Links.
			'a'      => array(
				'href'   => array(),
				'title'  => array(),
				'rel'    => array(),
				'class'  => array(),
				'id'     => array(),
				'target' => array(),
			),

			// Span.
			'span'   => array(
				'class' => array(),
				'id'    => array(),
				'style' => array(),
			),

			// Formatting.
			'em'     => array(),
			'strong' => array(),
		)
	);
}